/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.BundleManagerService;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.metadata.OSGiMetaData;

public class ModuleRegisterService
implements Service<ModuleRegisterService> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.osgi");
    public static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"osgi", "registration"});
    private final Module module;
    private final OSGiMetaData metadata;
    private InjectedValue<BundleManagerService> injectedBundleManager = new InjectedValue();
    private ServiceName installedBundleName;

    private ModuleRegisterService(Module module, OSGiMetaData metadata) {
        this.module = module;
        this.metadata = metadata;
    }

    public static void addService(DeploymentPhaseContext phaseContext, Module module, OSGiMetaData metadata) {
        ModuleRegisterService service = new ModuleRegisterService(module, metadata);
        ServiceName serviceName = ModuleRegisterService.getServiceName(module.getIdentifier());
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceBuilder builder = serviceTarget.addService(serviceName, (Service)service);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManagerService.class, service.injectedBundleManager);
        builder.addDependency(ServiceModuleLoader.moduleServiceName((ModuleIdentifier)module.getIdentifier()));
        builder.addDependency(Services.FRAMEWORK_ACTIVATOR);
        builder.install();
    }

    public static void removeService(DeploymentUnit deploymentUnit) {
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ServiceName serviceName = ModuleRegisterService.getServiceName(module.getIdentifier());
        ServiceController serviceController = deploymentUnit.getServiceRegistry().getService(serviceName);
        if (serviceController != null) {
            serviceController.setMode(ServiceController.Mode.REMOVE);
        }
    }

    public static ServiceName getServiceName(ModuleIdentifier moduleIdentifier) {
        return SERVICE_NAME_BASE.append(new String[]{moduleIdentifier.toString()});
    }

    public synchronized void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        log.debugf("Starting: %s in mode %s", (Object)controller.getName(), (Object)controller.getMode());
        log.infof("Register module: %s", (Object)this.module);
        try {
            ServiceTarget serviceTarget = context.getChildTarget();
            BundleManagerService bundleManager = (BundleManagerService)this.injectedBundleManager.getValue();
            this.installedBundleName = bundleManager.registerModule(serviceTarget, this.module, this.metadata);
        }
        catch (Throwable t) {
            throw new StartException("Failed to register module: " + this.module, t);
        }
    }

    public synchronized void stop(StopContext context) {
        ServiceController controller = context.getController();
        log.debugf("Stopping: %s in mode %s", (Object)controller.getName(), (Object)controller.getMode());
        log.infof("Unregister module: %s", (Object)this.module);
        try {
            BundleManagerService bundleManager = (BundleManagerService)this.injectedBundleManager.getValue();
            bundleManager.unregisterModule(this.module.getIdentifier());
        }
        catch (Throwable t) {
            log.errorf(t, "Failed to uninstall module: %s", (Object)this.module);
        }
    }

    public ModuleRegisterService getValue() throws IllegalStateException {
        return this;
    }

    public ServiceName getInstalledBundleName() {
        return this.installedBundleName;
    }
}

