/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.log4j.Logger;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.common.type.Classes;
import org.switchyard.component.soap.DefaultMessageComposer;
import org.switchyard.component.soap.DefaultMessageDecomposer;
import org.switchyard.component.soap.MessageComposer;
import org.switchyard.component.soap.MessageDecomposer;
import org.switchyard.component.soap.PortName;
import org.switchyard.component.soap.WebServiceConsumeException;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.util.SOAPUtil;
import org.switchyard.component.soap.util.WSDLUtil;

public class OutboundHandler
extends BaseHandler {
    private static final Logger LOGGER = Logger.getLogger(OutboundHandler.class);
    private MessageComposer _composer;
    private Set<QName> _composerMappedHeaderNames = new LinkedHashSet<QName>();
    private MessageDecomposer _decomposer;
    private Set<QName> _decomposerMappedVariableNames = new LinkedHashSet<QName>();
    private Dispatch<SOAPMessage> _dispatcher;
    private Port _port;
    private SOAPBindingModel _config;

    public OutboundHandler(SOAPBindingModel config) {
        this._config = config;
        this._composerMappedHeaderNames.addAll(config.getComposerMappedVariableNames());
        this._decomposerMappedVariableNames.addAll(config.getDecomposerMappedVariableNames());
        String composer = config.getComposer();
        String decomposer = config.getDecomposer();
        if (composer != null && composer.length() > 0) {
            try {
                Class<MessageComposer> composerClass = Classes.forName((String)composer, ((Object)((Object)this)).getClass()).asSubclass(MessageComposer.class);
                this._composer = composerClass.newInstance();
            }
            catch (Exception cnfe) {
                LOGGER.error((Object)"Could not instantiate composer", (Throwable)cnfe);
            }
        }
        if (this._composer == null) {
            this._composer = new DefaultMessageComposer();
        }
        if (decomposer != null && decomposer.length() > 0) {
            try {
                Class<MessageDecomposer> decomposerClass = Classes.forName((String)decomposer, ((Object)((Object)this)).getClass()).asSubclass(MessageDecomposer.class);
                this._decomposer = decomposerClass.newInstance();
            }
            catch (Exception cnfe) {
                LOGGER.error((Object)"Could not instantiate decomposer", (Throwable)cnfe);
            }
        }
        if (this._decomposer == null) {
            this._decomposer = new DefaultMessageDecomposer();
        }
        this._decomposer = new DefaultMessageDecomposer();
    }

    public void start() throws WebServiceConsumeException {
        if (this._dispatcher == null) {
            try {
                PortName portName = this._config.getPort();
                javax.wsdl.Service wsdlService = WSDLUtil.getService(this._config.getWsdl(), portName);
                this._port = WSDLUtil.getPort(wsdlService, portName);
                portName.setServiceQName(wsdlService.getQName());
                portName.setName(this._port.getName());
                URL wsdlUrl = WSDLUtil.getURL(this._config.getWsdl());
                LOGGER.info((Object)("Creating dispatch with WSDL " + wsdlUrl));
                Service service = Service.create((URL)wsdlUrl, (QName)portName.getServiceQName());
                LOGGER.info((Object)("Creating dispatch with service " + portName.getServiceQName() + " and port " + portName.getPortQName()));
                this._dispatcher = service.createDispatch(portName.getPortQName(), SOAPMessage.class, Service.Mode.MESSAGE, new WebServiceFeature[]{new AddressingFeature(false, false)});
            }
            catch (MalformedURLException e) {
                throw new WebServiceConsumeException(e);
            }
            catch (WSDLException wsdle) {
                throw new WebServiceConsumeException(wsdle);
            }
        }
    }

    public void stop() {
        this._composerMappedHeaderNames.clear();
        this._decomposerMappedVariableNames.clear();
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        try {
            SOAPMessage request = this._decomposer.decompose(exchange, this._decomposerMappedVariableNames);
            SOAPMessage response = this.invokeService(request);
            if (response != null) {
                Message message = this._composer.compose(response, exchange, this._composerMappedHeaderNames);
                exchange.send(message);
            }
        }
        catch (SOAPException se) {
            throw new HandlerException("Unexpected exception handling SOAP Message", (Throwable)se);
        }
    }

    private SOAPMessage invokeService(SOAPMessage soapMessage) throws SOAPException {
        SOAPMessage response = null;
        try {
            String firstBodyElement = SOAPUtil.getFirstBodyElement(soapMessage);
            if (WSDLUtil.isOneWay(this._port, firstBodyElement)) {
                this._dispatcher.invokeOneWay((Object)soapMessage);
            } else {
                response = (SOAPMessage)this._dispatcher.invoke((Object)soapMessage);
            }
        }
        catch (SOAPFaultException sfex) {
            response = SOAPUtil.generateFault(sfex);
        }
        catch (Exception ex) {
            throw new SOAPException("Cannot process SOAP request", (Throwable)ex);
        }
        return response;
    }
}

