/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.management.mbean.ManagedRoute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="Managed Suspendable Route")
public class ManagedSuspendableRoute
extends ManagedRoute {
    public ManagedSuspendableRoute(CamelContext context, Route route) {
        super(context, route);
    }

    @ManagedOperation(description="Suspend route")
    public void suspend() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.suspendRoute(this.getRouteId());
    }

    @ManagedOperation(description="Suspend route (using timeout in seconds)")
    public void suspend(long timeout) throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.suspendRoute(this.getRouteId(), timeout, TimeUnit.SECONDS);
    }

    @ManagedOperation(description="Resume Route")
    public void resume() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.resumeRoute(this.getRouteId());
    }
}

