/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;

@XmlRootElement(name="csv")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CsvDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private String delimiter;

    public CsvDataFormat() {
        super("csv");
    }

    public CsvDataFormat(String delimiter) {
        this();
        this.setDelimiter(delimiter);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat) {
        if (this.delimiter != null) {
            if (this.delimiter.length() > 1) {
                throw new IllegalArgumentException("Delimiter must have a length of one!");
            }
            this.setProperty(dataFormat, "delimiter", this.delimiter);
        } else {
            this.setProperty(dataFormat, "delimiter", ",");
        }
    }
}

