/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.camel.spi.ClassResolver;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.Assert;

public class CamelClassPathResource
extends ClassPathResource {
    private final ClassResolver resolver;

    public CamelClassPathResource(ClassResolver resolver, String path, ClassLoader classLoader) {
        super(path, classLoader);
        Assert.notNull((Object)resolver, (String)"Resolver must not be null");
        this.resolver = resolver;
    }

    public InputStream getInputStream() throws IOException {
        InputStream is = this.resolver.loadResourceAsStream(this.getPath());
        if (is == null) {
            return super.getInputStream();
        }
        return is;
    }

    public URL getURL() throws IOException {
        URL url = this.resolver.loadResourceAsURL(this.getPath());
        if (url == null) {
            return super.getURL();
        }
        return url;
    }
}

