/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.jaxb.internal;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.switchyard.Message;
import org.switchyard.config.model.Scannable;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.transform.BaseTransformer;

@Scannable(value=false)
public class JAXBUnmarshalTransformer<F, T>
extends BaseTransformer<Message, Message> {
    private String _contextPath;
    private JAXBContext _jaxbContext;

    public JAXBUnmarshalTransformer(QName from, QName to, String contextPath) throws SwitchYardException {
        super(from, to);
        this._contextPath = contextPath;
        try {
            this._jaxbContext = JAXBContext.newInstance((String)contextPath);
        }
        catch (JAXBException e) {
            throw new SwitchYardException("Failed to create JAXBContext for contextPath '" + this._contextPath + "'.", (Throwable)e);
        }
    }

    public Message transform(Message message) {
        Unmarshaller unmarshaller;
        try {
            unmarshaller = this._jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new SwitchYardException("Failed to create Unmarshaller for contextPath '" + this._contextPath + "'.", (Throwable)e);
        }
        try {
            Object unmarshalledObject = unmarshaller.unmarshal((Source)message.getContent(Source.class));
            if (unmarshalledObject instanceof JAXBElement) {
                message.setContent(((JAXBElement)unmarshalledObject).getValue());
            } else {
                message.setContent(unmarshalledObject);
            }
        }
        catch (JAXBException e) {
            throw new SwitchYardException("Failed to unmarshall for contextPath '" + this._contextPath + "'.", (Throwable)e);
        }
        return message;
    }
}

