/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.common.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public final class Strings {
    private Strings() {
    }

    public static String trimToNull(String str) {
        if (str != null && (str = str.trim()).length() == 0) {
            str = null;
        }
        return str;
    }

    public static List<String> splitTrimToNull(String str, String delim) {
        ArrayList<String> list = new ArrayList<String>();
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, delim);
            while (st.hasMoreTokens()) {
                String s = Strings.trimToNull(st.nextToken());
                if (s == null) continue;
                list.add(s);
            }
        }
        return Collections.unmodifiableList(list);
    }

    public static String[] splitTrimToNullArray(String str, String delim) {
        List<String> list = Strings.splitTrimToNull(str, delim);
        return list.toArray(new String[list.size()]);
    }

    public static Set<String> uniqueSplitTrimToNull(String str, String delim) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, delim);
            while (st.hasMoreTokens()) {
                String s = Strings.trimToNull(st.nextToken());
                if (s == null) continue;
                set.add(s);
            }
        }
        return Collections.unmodifiableSet(set);
    }

    public static String[] uniqueSplitTrimToNullArray(String str, String delim) {
        Set<String> set = Strings.uniqueSplitTrimToNull(str, delim);
        return set.toArray(new String[set.size()]);
    }

    public static String concat(String ... str) {
        return Strings.concat(null, str);
    }

    public static String concat(String delim, String ... str) {
        return Strings.concat(delim, true, str);
    }

    public static String concat(String delim, boolean trimToNull, String ... str) {
        if (str != null && str.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < str.length; ++i) {
                String s = str[i];
                if (trimToNull) {
                    s = Strings.trimToNull(s);
                }
                if (s == null) continue;
                sb.append(s);
                if (i >= str.length - 1) continue;
                sb.append(delim);
            }
            return sb.toString();
        }
        return null;
    }
}

