/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.config.model.v1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.switchyard.common.io.resource.Resource;
import org.switchyard.common.io.resource.ResourceType;
import org.switchyard.common.io.resource.SimpleResource;
import org.switchyard.component.bpm.config.model.BpmComponentImplementationModel;
import org.switchyard.component.bpm.config.model.ProcessActionModel;
import org.switchyard.component.bpm.config.model.TaskHandlerModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.v1.V1ComponentImplementationModel;
import org.switchyard.config.model.resource.ResourceModel;

public class V1BpmComponentImplementationModel
extends V1ComponentImplementationModel
implements BpmComponentImplementationModel {
    private List<ProcessActionModel> _processActions = new ArrayList<ProcessActionModel>();
    private List<ResourceModel> _resources = new ArrayList<ResourceModel>();
    private List<TaskHandlerModel> _taskHandlers = new ArrayList<TaskHandlerModel>();

    public V1BpmComponentImplementationModel() {
        super("bpm", "urn:switchyard-component-bpm:config:1.0");
        this.setModelChildrenOrder(new String[]{"processAction", "resource", "taskHandler"});
    }

    public V1BpmComponentImplementationModel(Configuration config, Descriptor desc) {
        super(config, desc);
        for (Configuration processAction_config : config.getChildren("processAction")) {
            ProcessActionModel processAction = (ProcessActionModel)this.readModel(processAction_config);
            if (processAction == null) continue;
            this._processActions.add(processAction);
        }
        for (Configuration resource_config : config.getChildren("resource")) {
            ResourceModel resource = (ResourceModel)this.readModel(resource_config);
            if (resource == null) continue;
            this._resources.add(resource);
        }
        for (Configuration taskHandler_config : config.getChildren("taskHandler")) {
            TaskHandlerModel taskHandler = (TaskHandlerModel)this.readModel(taskHandler_config);
            if (taskHandler == null) continue;
            this._taskHandlers.add(taskHandler);
        }
        this.setModelChildrenOrder(new String[]{"processAction", "resource", "taskHandler"});
    }

    @Override
    public Resource getProcessDefinition() {
        String pd = this.getModelAttribute("processDefinition");
        if (pd != null) {
            String pdt = this.getModelAttribute("processDefinitionType");
            return new SimpleResource(pd, pdt != null ? ResourceType.valueOf((String)pdt) : null);
        }
        return null;
    }

    @Override
    public BpmComponentImplementationModel setProcessDefinition(Resource processDefinition) {
        this.setModelAttribute("processDefinition", processDefinition != null ? processDefinition.getLocation() : null);
        ResourceType pdt = processDefinition != null ? processDefinition.getType() : null;
        this.setModelAttribute("processDefinitionType", pdt != null ? pdt.getName() : null);
        return this;
    }

    @Override
    public String getProcessId() {
        return this.getModelAttribute("processId");
    }

    @Override
    public BpmComponentImplementationModel setProcessId(String processId) {
        this.setModelAttribute("processId", processId);
        return this;
    }

    @Override
    public String getMessageContentName() {
        return this.getModelAttribute("messageContentName");
    }

    @Override
    public BpmComponentImplementationModel setMessageContentName(String messageContentName) {
        this.setModelAttribute("messageContentName", messageContentName);
        return this;
    }

    @Override
    public List<ProcessActionModel> getProcessActions() {
        return Collections.unmodifiableList(this._processActions);
    }

    @Override
    public BpmComponentImplementationModel addProcessAction(ProcessActionModel processAction) {
        this.addChildModel(processAction);
        this._processActions.add(processAction);
        return this;
    }

    @Override
    public List<ResourceModel> getResources() {
        return Collections.unmodifiableList(this._resources);
    }

    @Override
    public BpmComponentImplementationModel addResource(ResourceModel resource) {
        this.addChildModel((Model)resource);
        this._resources.add(resource);
        return this;
    }

    @Override
    public List<TaskHandlerModel> getTaskHandlers() {
        return Collections.unmodifiableList(this._taskHandlers);
    }

    @Override
    public BpmComponentImplementationModel addTaskHandler(TaskHandlerModel taskHandler) {
        this.addChildModel(taskHandler);
        this._taskHandlers.add(taskHandler);
        return this;
    }
}

