/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.bpm.task;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.ServiceReference;
import org.switchyard.SynchronousInOutHandler;
import org.switchyard.common.lang.Strings;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.component.bpm.task.BaseTaskHandler;
import org.switchyard.component.bpm.task.Task;
import org.switchyard.component.bpm.task.TaskManager;
import org.switchyard.exception.DeliveryException;
import org.switchyard.metadata.BaseExchangeContract;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.ServiceOperation;

public class SwitchYardServiceTaskHandler
extends BaseTaskHandler {
    private static final Logger LOGGER = Logger.getLogger(SwitchYardServiceTaskHandler.class);
    public static final String SWITCHYARD_SERVICE = "SwitchYard Service";
    public static final String SERVICE_NAME = "ServiceName";
    public static final String SERVICE_OPERATION_NAME = "ServiceOperationName";
    public static final String INPUT_MESSAGE_VAR = "InputMessageVariable";
    public static final String OUTPUT_MESSAGE_VAR = "OutputMessageVariable";

    public SwitchYardServiceTaskHandler() {
        super(SWITCHYARD_SERVICE);
    }

    public SwitchYardServiceTaskHandler(String name) {
        super(name);
    }

    @Override
    public void executeTask(Task task, TaskManager taskManager) {
        String problem = null;
        Map<String, Object> parameters = task.getParameters();
        HashMap<String, Object> results = null;
        QName serviceName = this.getServiceName(parameters);
        if (serviceName != null) {
            ServiceReference serviceRef = this.getServiceDomain().getService(serviceName);
            if (serviceRef != null) {
                Exchange exchangeIn;
                ExchangeContract exchangeContract = this.getExchangeContract(serviceRef, parameters);
                ExchangePattern exchangePattern = exchangeContract.getServiceOperation().getExchangePattern();
                SynchronousInOutHandler inOutHandler = null;
                if (ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                    inOutHandler = new SynchronousInOutHandler();
                    exchangeIn = serviceRef.createExchange(exchangeContract, (ExchangeHandler)inOutHandler);
                } else {
                    exchangeIn = serviceRef.createExchange(exchangeContract);
                }
                Context context = exchangeIn.getContext();
                for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                    context.setProperty(entry.getKey(), entry.getValue(), Scope.IN);
                }
                Message message = exchangeIn.createMessage();
                Object content = task.getProcessInstanceVariable(this.getInputContentName(task));
                if (content != null) {
                    message.setContent(content);
                }
                if (inOutHandler != null && ExchangePattern.IN_OUT.equals((Object)exchangePattern)) {
                    exchangeIn.send(message);
                    try {
                        Exchange exchangeOut = inOutHandler.waitForOut();
                        context = exchangeOut.getContext();
                        message = exchangeOut.getMessage();
                        content = message.getContent();
                        task.setProcessInstanceVariable(this.getOutputContentName(task), content);
                        results = new HashMap<String, Object>();
                        for (Property property : context.getProperties(Scope.OUT)) {
                            results.put(property.getName(), property.getValue());
                        }
                    }
                    catch (DeliveryException e) {
                        problem = e.getMessage();
                    }
                } else {
                    exchangeIn.send(message);
                }
            } else {
                problem = "serviceRef (" + serviceName + ") == null";
            }
        } else {
            problem = "ServiceName == null";
        }
        if (problem == null) {
            taskManager.completeTask(task.getId(), results);
        } else {
            LOGGER.error((Object)problem);
            taskManager.abortTask(task.getId());
        }
    }

    private QName getServiceName(Map<String, Object> parameters) {
        String tns;
        QName serviceName = null;
        Object p = parameters.get(SERVICE_NAME);
        if (p instanceof QName) {
            serviceName = (QName)p;
        } else if (p instanceof String) {
            serviceName = XMLHelper.createQName((String)((String)p));
        }
        if (serviceName != null && Strings.trimToNull((String)serviceName.getNamespaceURI()) == null && (tns = this.getTargetNamespace()) != null) {
            serviceName = XMLHelper.createQName((String)tns, (String)serviceName.getLocalPart());
        }
        return serviceName;
    }

    private String getInputContentName(Task task) {
        String contentName = (String)task.getParameter(INPUT_MESSAGE_VAR);
        if (contentName == null) {
            contentName = this.getMessageContentName();
        }
        return contentName;
    }

    private String getOutputContentName(Task task) {
        String contentName = (String)task.getParameter(OUTPUT_MESSAGE_VAR);
        if (contentName == null) {
            contentName = this.getMessageContentName();
        }
        return contentName;
    }

    private ExchangeContract getExchangeContract(ServiceReference serviceRef, Map<String, Object> parameters) {
        ExchangeContract exchangeContract;
        Object on = parameters.get(SERVICE_OPERATION_NAME);
        if (on instanceof String) {
            String operationName = (String)on;
            ServiceOperation operation = serviceRef.getInterface().getOperation(operationName);
            if (operation == null) {
                throw new RuntimeException("operationName [" + operationName + "] == null");
            }
            exchangeContract = new BaseExchangeContract(operation);
        } else {
            exchangeContract = ExchangeContract.IN_ONLY;
        }
        return exchangeContract;
    }
}

