/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.milyn.assertion.AssertArgument;
import org.milyn.payload.FilterResult;
import org.milyn.validation.OnFail;
import org.milyn.validation.OnFailResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationResult
extends FilterResult {
    private Map<OnFail, List<OnFailResult>> results = new HashMap<OnFail, List<OnFailResult>>();
    private OnFailResult fatal;

    public ValidationResult() {
        this.results.put(OnFail.OK, new ArrayList());
        this.results.put(OnFail.WARN, new ArrayList());
        this.results.put(OnFail.ERROR, new ArrayList());
    }

    public List<OnFailResult> getOKs() {
        return Collections.unmodifiableList(this.results.get((Object)OnFail.OK));
    }

    public List<OnFailResult> getWarnings() {
        return Collections.unmodifiableList(this.results.get((Object)OnFail.WARN));
    }

    public List<OnFailResult> getErrors() {
        return Collections.unmodifiableList(this.results.get((Object)OnFail.ERROR));
    }

    public OnFailResult getFatal() {
        return this.fatal;
    }

    public int getNumFailures() {
        int numFailures = 0;
        Collection<List<OnFailResult>> values = this.results.values();
        for (List<OnFailResult> value : values) {
            numFailures += value.size();
        }
        if (this.fatal != null) {
            ++numFailures;
        }
        return numFailures;
    }

    protected void addResult(OnFailResult result, OnFail onFail) {
        AssertArgument.isNotNull(result, "result");
        AssertArgument.isNotNull((Object)onFail, "onFail");
        if (onFail == OnFail.FATAL) {
            this.fatal = result;
        } else {
            this.results.get((Object)onFail).add(result);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OK Failures:\n");
        this.addResultMessages(this.getOKs(), stringBuilder);
        stringBuilder.append("WARN Failures:\n");
        this.addResultMessages(this.getWarnings(), stringBuilder);
        stringBuilder.append("ERROR Failures:\n");
        this.addResultMessages(this.getErrors(), stringBuilder);
        stringBuilder.append("FATAL Failure:\n");
        if (this.fatal != null) {
            stringBuilder.append("\t" + this.fatal.getMessage() + "\n");
        } else {
            stringBuilder.append("\t(none)\n");
        }
        return stringBuilder.toString();
    }

    private void addResultMessages(List<OnFailResult> results, StringBuilder stringBuilder) {
        if (results.isEmpty()) {
            stringBuilder.append("\t(none)\n");
        } else {
            for (OnFailResult result : results) {
                stringBuilder.append("\t- " + result.getMessage() + "\n");
            }
        }
    }
}

