/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.admin.Binding;
import org.switchyard.admin.ComponentReference;
import org.switchyard.admin.ComponentService;
import org.switchyard.admin.Transformer;
import org.switchyard.admin.base.BaseApplication;
import org.switchyard.admin.base.BaseBinding;
import org.switchyard.admin.base.BaseComponentReference;
import org.switchyard.admin.base.BaseComponentService;
import org.switchyard.admin.base.BaseService;
import org.switchyard.admin.base.BaseSwitchYard;
import org.switchyard.admin.base.BaseTransformer;
import org.switchyard.config.OutputKey;
import org.switchyard.config.model.TypedModel;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentImplementationModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.ComponentReferenceModel;
import org.switchyard.config.model.composite.ComponentServiceModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.composite.InterfaceModel;
import org.switchyard.config.model.transform.TransformModel;
import org.switchyard.config.model.transform.TransformsModel;
import org.switchyard.deploy.internal.AbstractDeployment;
import org.switchyard.deploy.internal.DeploymentListener;

public class SwitchYardBuilder
implements DeploymentListener {
    private static Logger _log = Logger.getLogger(SwitchYardBuilder.class);
    private BaseSwitchYard _switchYard;

    public SwitchYardBuilder(BaseSwitchYard switchYard) {
        this._switchYard = switchYard;
    }

    public void initializing(AbstractDeployment deployment) {
        QName applicationName = deployment.getName();
        if (applicationName == null) {
            _log.warn((Object)"initializing() received deployment with null application name.");
            return;
        }
        this._switchYard.addApplication(new BaseApplication(this._switchYard, applicationName));
    }

    public void initialized(AbstractDeployment deployment) {
    }

    public void initializationFailed(AbstractDeployment deployment, Throwable throwable) {
        QName applicationName = deployment.getName();
        if (applicationName == null) {
            _log.warn((Object)"initializationFailed() received deployment with null application name.");
            return;
        }
        this._switchYard.removeApplication(applicationName);
    }

    public void starting(AbstractDeployment deployment) {
    }

    public void started(AbstractDeployment deployment) {
    }

    public void startFailed(AbstractDeployment deployment, Throwable throwable) {
    }

    public void stopping(AbstractDeployment deployment) {
    }

    public void stopped(AbstractDeployment deployment) {
    }

    public void stopFailed(AbstractDeployment deployment, Throwable throwable) {
    }

    public void destroying(AbstractDeployment deployment) {
    }

    public void destroyed(AbstractDeployment deployment) {
        QName applicationName = deployment.getName();
        if (applicationName == null) {
            _log.warn((Object)"destroyed() received deployment with null application name.");
            return;
        }
        this._switchYard.removeApplication(applicationName);
    }

    public void componentServiceDeployed(AbstractDeployment deployment, ComponentModel componentModel) {
        QName applicationName = deployment.getName();
        if (applicationName == null) {
            _log.warn((Object)"componentServiceDeployed() received deployment with null application name.");
            return;
        }
        BaseApplication application = (BaseApplication)this._switchYard.getApplication(applicationName);
        if (componentModel.getServices().size() != 1) {
            _log.warn((Object)"componentServiceDeployed() received component with service count != 1.");
            return;
        }
        ComponentServiceModel componentServiceModel = (ComponentServiceModel)componentModel.getServices().get(0);
        QName name = componentServiceModel.getQName();
        String interfaceName = this.getInterfaceName((InterfaceModel)componentServiceModel.getInterface());
        String implementation = this.getComponentImplementationType(componentModel);
        String implementationConfiguration = this.getComponentImplementationConfiguration(componentModel);
        ArrayList<ComponentReference> references = new ArrayList<ComponentReference>();
        for (ComponentReferenceModel referenceModel : componentModel.getReferences()) {
            references.add(new BaseComponentReference(referenceModel.getQName(), this.getInterfaceName((InterfaceModel)referenceModel.getInterface())));
        }
        application.addComponentService(new BaseComponentService(name, implementation, implementationConfiguration, interfaceName, application, references));
    }

    public void componentServiceUndeployed(AbstractDeployment deployment, QName serviceName) {
        QName applicationName = deployment.getName();
        if (applicationName == null) {
            _log.warn((Object)"componentServiceUndeployed() received deployment with null application name.");
            return;
        }
        BaseApplication application = (BaseApplication)this._switchYard.getApplication(applicationName);
        application.removeComponentService(serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceDeployed(AbstractDeployment deployment, CompositeServiceModel serviceModel) {
        QName applicationName = deployment.getName();
        if (applicationName == null) {
            _log.warn((Object)"serviceDeployed() received deployment with null application name.");
            return;
        }
        BaseApplication application = (BaseApplication)this._switchYard.getApplication(applicationName);
        QName name = serviceModel.getQName();
        String interfaceName = this.getInterfaceName(serviceModel.getInterface());
        ComponentService promotedService = this.getPromotedService(application, serviceModel);
        ArrayList<Binding> gateways = new ArrayList<Binding>();
        for (BindingModel bindingModel : serviceModel.getBindings()) {
            String bindingConfiguration = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                bindingModel.getModelConfiguration().write((OutputStream)baos, new OutputKey[]{OutputKey.OMIT_XML_DECLARATION});
                bindingConfiguration = baos.toString();
            }
            catch (IOException e) {
                _log.error((Object)"Could not retrieve binding configuration as string.", (Throwable)e);
            }
            finally {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    e.getMessage();
                }
            }
            gateways.add(new BaseBinding(bindingModel.getType(), bindingConfiguration));
        }
        BaseService service = new BaseService(name, interfaceName, application, promotedService, gateways);
        application.addService(service);
    }

    public void serviceUndeployed(AbstractDeployment deployment, QName serviceName) {
        QName applicationName = deployment.getName();
        if (applicationName == null) {
            _log.warn((Object)"serviceUndeployed() received deployment with null application name.");
            return;
        }
        BaseApplication application = (BaseApplication)this._switchYard.getApplication(applicationName);
        application.removeService(serviceName);
    }

    public void transformersRegistered(AbstractDeployment deployment, TransformsModel transformsModel) {
        if (transformsModel == null) {
            return;
        }
        QName applicationName = deployment.getName();
        if (applicationName == null) {
            _log.warn((Object)"serviceUndeployed() received deployment with null application name.");
            return;
        }
        List transformModels = transformsModel.getTransforms();
        if (transformModels == null) {
            return;
        }
        BaseApplication application = (BaseApplication)this._switchYard.getApplication(applicationName);
        ArrayList<Transformer> transformers = new ArrayList<Transformer>(transformModels.size());
        for (TransformModel transformModel : transformModels) {
            String type = transformModel instanceof TypedModel ? ((TypedModel)transformModel).getType() : null;
            transformers.add(new BaseTransformer(transformModel.getFrom(), transformModel.getTo(), type));
        }
        application.setTransformers(transformers);
    }

    private ComponentService getPromotedService(BaseApplication application, CompositeServiceModel compositeService) {
        ComponentServiceModel componentServiceModel = compositeService.getComponentService();
        if (componentServiceModel == null) {
            return null;
        }
        return application.getComponentService(componentServiceModel.getQName());
    }

    private String getInterfaceName(InterfaceModel interfaceModel) {
        if (interfaceModel == null) {
            return null;
        }
        return interfaceModel.getInterface();
    }

    private String getComponentImplementationType(ComponentModel componentModel) {
        ComponentImplementationModel implementationModel = componentModel.getImplementation();
        if (implementationModel == null) {
            return null;
        }
        return implementationModel.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getComponentImplementationConfiguration(ComponentModel componentModel) {
        ComponentImplementationModel implementationModel = componentModel.getImplementation();
        if (implementationModel == null) {
            return null;
        }
        String configuration = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            implementationModel.getModelConfiguration().write((OutputStream)baos, new OutputKey[]{OutputKey.OMIT_XML_DECLARATION});
            configuration = baos.toString();
        }
        catch (IOException e) {
            _log.error((Object)"Could not retrieve implementation configuration as string.", (Throwable)e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                e.getMessage();
            }
        }
        return configuration;
    }
}

