/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.remote.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.internal.DefaultContext;
import org.switchyard.remote.RemoteInvoker;
import org.switchyard.remote.RemoteMessage;
import org.switchyard.serial.FormatType;
import org.switchyard.serial.Serializer;
import org.switchyard.serial.SerializerFactory;
import org.switchyard.transform.TransformSequence;

public class HttpInvoker
implements RemoteInvoker {
    public static final String SERVICE_HEADER = "switchyard-service";
    private static Logger _log = Logger.getLogger(HttpInvoker.class);
    private Serializer _serializer = SerializerFactory.create((FormatType)FormatType.JSON, null, (boolean)true);
    private URL _endpoint;

    public HttpInvoker(String endpoint) {
        try {
            this._endpoint = new URL(endpoint);
        }
        catch (MalformedURLException badURL) {
            throw new IllegalArgumentException("Invalid URL for remote endpoint: " + endpoint, badURL);
        }
    }

    public HttpInvoker(URL endpoint) {
        this._endpoint = endpoint;
    }

    @Override
    public void invoke(Exchange exchange) {
        RemoteMessage request = new RemoteMessage().setDomain(exchange.getProvider().getDomain().getName()).setService(exchange.getProvider().getName()).setContent(exchange.getMessage().getContent()).setContext(exchange.getContext());
        try {
            RemoteMessage reply = this.invoke(request);
            if (this.isInOut(exchange) && reply != null) {
                Message msg = exchange.getMessage().setContent(reply.getContent());
                if (reply.isFault()) {
                    exchange.sendFault(msg);
                } else {
                    exchange.send(msg);
                }
            }
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            exchange.sendFault(exchange.createMessage().setContent((Object)ioEx));
        }
    }

    @Override
    public RemoteMessage invoke(RemoteMessage request) throws IOException {
        RemoteMessage reply = null;
        HttpURLConnection conn = null;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking " + request.getService() + " at endpoint " + this._endpoint.toString()));
        }
        conn = (HttpURLConnection)this._endpoint.openConnection();
        conn.setDoOutput(true);
        conn.addRequestProperty(SERVICE_HEADER, request.getService().toString());
        conn.connect();
        OutputStream os = conn.getOutputStream();
        Context ctx = this.cloneContext(request.getContext());
        request.setContext(ctx);
        this._serializer.serialize((Object)request, RemoteMessage.class, os);
        os.flush();
        os.close();
        if (conn.getResponseCode() == 200) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing reply for service " + request.getService()));
            }
            reply = (RemoteMessage)this._serializer.deserialize(conn.getInputStream(), RemoteMessage.class);
        }
        return reply;
    }

    private Context cloneContext(Context context) {
        DefaultContext newCtx = new DefaultContext();
        if (context == null) {
            return newCtx;
        }
        newCtx.setProperties(context.getProperties());
        Property inTransform = newCtx.getProperty(TransformSequence.class.getName(), Scope.IN);
        Property outTransform = newCtx.getProperty(TransformSequence.class.getName(), Scope.OUT);
        if (inTransform != null) {
            newCtx.removeProperty(inTransform);
        }
        if (outTransform != null) {
            newCtx.removeProperty(outTransform);
        }
        return newCtx;
    }

    private boolean isInOut(Exchange exchange) {
        return ExchangePattern.IN_OUT.equals((Object)exchange.getContract().getConsumerOperation().getExchangePattern());
    }
}

