/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.remote.infinispan;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.infinispan.Cache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.tree.Node;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.TreeCacheFactory;
import org.switchyard.remote.RemoteEndpoint;
import org.switchyard.remote.RemoteRegistry;
import org.switchyard.serial.FormatType;
import org.switchyard.serial.Serializer;
import org.switchyard.serial.SerializerFactory;

public class InfinispanRegistry
implements RemoteRegistry {
    private static final QName ROOT_DOMAIN = new QName("all-domains");
    private static Logger _log = Logger.getLogger(InfinispanRegistry.class);
    private String _nodeName;
    private TreeCache<String, String> _serviceCache;
    private Serializer _serializer = SerializerFactory.create((FormatType)FormatType.JSON, null, (boolean)true);

    public InfinispanRegistry(Cache<String, String> serviceCache) {
        this._serviceCache = new TreeCacheFactory().createTreeCache(serviceCache);
        this._serializer = SerializerFactory.create((FormatType)FormatType.JSON, null, (boolean)true);
        serviceCache.getCacheManager().addListener((Object)new MemberDropListener());
        this._nodeName = serviceCache.getCacheManager().getAddress().toString();
    }

    @Override
    public void addEndpoint(RemoteEndpoint endpoint) {
        if (this._serviceCache.get(this.toFQN(ROOT_DOMAIN, endpoint.getServiceName()), (Object)this._nodeName) != null) {
            _log.info((Object)("Service " + endpoint.getServiceName() + " is already registered in the cache"));
            return;
        }
        try {
            endpoint.setNode(this._nodeName);
            String epStr = new String(this._serializer.serialize((Object)endpoint, RemoteEndpoint.class));
            this._serviceCache.put(this.toFQN(ROOT_DOMAIN, endpoint.getServiceName()), (Object)this._nodeName, (Object)epStr);
        }
        catch (IOException ioEx) {
            _log.warn((Object)("Failed to add service " + endpoint.getServiceName() + " to remote registry."), (Throwable)ioEx);
        }
    }

    @Override
    public void removeEndpoint(RemoteEndpoint endpoint) {
        if (this._nodeName != null) {
            this._serviceCache.remove(this.toFQN(ROOT_DOMAIN, endpoint.getServiceName()), (Object)this._nodeName);
        }
    }

    @Override
    public List<RemoteEndpoint> getEndpoints(QName serviceName) {
        LinkedList<RemoteEndpoint> services = new LinkedList<RemoteEndpoint>();
        String serviceFQN = this.toFQN(ROOT_DOMAIN, serviceName);
        Set nodes = this._serviceCache.getKeys(serviceFQN);
        if (nodes != null) {
            for (String node : nodes) {
                String epStr = (String)this._serviceCache.get(serviceFQN, (Object)node);
                if (epStr == null) continue;
                try {
                    RemoteEndpoint ep = (RemoteEndpoint)this._serializer.deserialize(epStr.getBytes(), RemoteEndpoint.class);
                    services.add(ep);
                }
                catch (IOException ioEx) {
                    _log.warn((Object)("Failed to deserialize remote endpoint: " + epStr), (Throwable)ioEx);
                }
            }
        }
        return services;
    }

    private String toFQN(QName domain) {
        return "/" + domain.toString();
    }

    private String toFQN(QName domain, QName service) {
        return this.toFQN(domain) + "/" + service.toString();
    }

    @Listener
    public class MemberDropListener {
        @ViewChanged
        public void viewChanged(ViewChangedEvent event) {
            ArrayList dropped = new ArrayList(event.getOldMembers());
            dropped.removeAll(event.getNewMembers());
            for (Address addr : dropped) {
                this.dropAllServices(addr);
            }
        }

        private void dropAllServices(Address address) {
            for (Node domainNode : InfinispanRegistry.this._serviceCache.getRoot().getChildren()) {
                for (Node serviceNode : domainNode.getChildren()) {
                    serviceNode.remove((Object)address.toString());
                }
            }
        }
    }
}

