/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.remote.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.logging.Logger;
import org.switchyard.Property;
import org.switchyard.remote.RemoteInvoker;
import org.switchyard.remote.RemoteMessage;
import org.switchyard.remote.RemoteMessages;
import org.switchyard.remote.http.HttpInvokerLabel;
import org.switchyard.serial.FormatType;
import org.switchyard.serial.Serializer;
import org.switchyard.serial.SerializerFactory;

public class HttpInvoker
implements RemoteInvoker {
    public static final String SERVICE_HEADER = "switchyard-service";
    private static Logger _log = Logger.getLogger(HttpInvoker.class);
    private Serializer _serializer = SerializerFactory.create((FormatType)FormatType.JSON, null, (boolean)true);
    private URL _endpoint;

    public HttpInvoker(String endpoint) {
        try {
            this._endpoint = new URL(endpoint);
        }
        catch (MalformedURLException badURL) {
            throw RemoteMessages.MESSAGES.invalidURLForEndpoint(endpoint, badURL);
        }
    }

    public HttpInvoker(URL endpoint) {
        this._endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteMessage invoke(RemoteMessage request) throws IOException {
        RemoteMessage reply = null;
        HttpURLConnection conn = null;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking " + request.getService() + " at endpoint " + this._endpoint.toString()));
        }
        conn = (HttpURLConnection)this._endpoint.openConnection();
        conn.setDoOutput(true);
        conn.addRequestProperty(SERVICE_HEADER, request.getService().toString());
        for (Property prop : request.getContext().getProperties(HttpInvokerLabel.HEADER.label())) {
            conn.addRequestProperty(prop.getName(), prop.getValue().toString());
        }
        conn.connect();
        OutputStream os = conn.getOutputStream();
        try {
            this._serializer.serialize((Object)request, RemoteMessage.class, os);
            os.flush();
        }
        finally {
            os.close();
        }
        if (conn.getResponseCode() == 200) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing reply for service " + request.getService()));
            }
            InputStream is = conn.getInputStream();
            try {
                reply = (RemoteMessage)this._serializer.deserialize(is, RemoteMessage.class);
            }
            finally {
                is.close();
            }
        }
        return reply;
    }
}

