/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.remote.cluster;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import org.switchyard.remote.RemoteEndpoint;
import org.switchyard.remote.cluster.BaseStrategy;

public class RoundRobinStrategy
extends BaseStrategy {
    private ConcurrentMap<QName, AtomicInteger> _endpointIdxs = new ConcurrentHashMap<QName, AtomicInteger>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteEndpoint selectEndpoint(QName serviceName) {
        if (this.getRegistry() == null) {
            return null;
        }
        RemoteEndpoint selectedEp = null;
        List<RemoteEndpoint> eps = this.getRegistry().getEndpoints(serviceName);
        if (!eps.isEmpty()) {
            AtomicInteger idx;
            this._endpointIdxs.putIfAbsent(serviceName, new AtomicInteger(0));
            AtomicInteger atomicInteger = idx = (AtomicInteger)this._endpointIdxs.get(serviceName);
            synchronized (atomicInteger) {
                idx.set(idx.get() % eps.size());
                selectedEp = eps.get(idx.getAndIncrement());
            }
        }
        return selectedEp;
    }
}

