/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.remote.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.logging.Logger;
import org.switchyard.Property;
import org.switchyard.common.codec.Base64;
import org.switchyard.remote.RemoteInvoker;
import org.switchyard.remote.RemoteMessage;
import org.switchyard.remote.RemoteMessages;
import org.switchyard.remote.http.HttpInvokerLabel;
import org.switchyard.serial.FormatType;
import org.switchyard.serial.Serializer;
import org.switchyard.serial.SerializerFactory;
import org.w3c.dom.Node;

public class HttpInvoker
implements RemoteInvoker {
    public static final String SERVICE_HEADER = "switchyard-service";
    public static final String WS_SECURITY_HEADER = "switchyard-webservice-security";
    public static final String AUTH_USERNAME = "auth.username";
    public static final String AUTH_PASSWORD = "auth.password";
    public static final String WS_SECURITY = "webservice.security";
    public static final QName WS_SECURITY_QNAME = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    private static Logger _log = Logger.getLogger(HttpInvoker.class);
    private Serializer _serializer = SerializerFactory.create((FormatType)FormatType.JSON, null, (boolean)true);
    private URL _endpoint;
    private Properties _properties = new Properties();

    public HttpInvoker(String endpoint) {
        try {
            this._endpoint = new URL(endpoint);
        }
        catch (MalformedURLException badURL) {
            throw RemoteMessages.MESSAGES.invalidURLForEndpoint(endpoint, badURL);
        }
    }

    public HttpInvoker(URL endpoint) {
        this._endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteMessage invoke(RemoteMessage request) throws IOException {
        RemoteMessage reply = null;
        HttpURLConnection conn = null;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking " + request.getService() + " at endpoint " + this._endpoint.toString()));
        }
        conn = (HttpURLConnection)this._endpoint.openConnection();
        conn.setDoOutput(true);
        conn.addRequestProperty(SERVICE_HEADER, request.getService().toString());
        for (Property prop : request.getContext().getProperties(HttpInvokerLabel.HEADER.label())) {
            conn.addRequestProperty(prop.getName(), prop.getValue().toString());
        }
        this.setupAuthentication(conn);
        conn.connect();
        try (OutputStream os = conn.getOutputStream();){
            this._serializer.serialize((Object)request, RemoteMessage.class, os);
            os.flush();
        }
        if (conn.getResponseCode() == 200) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing reply for service " + request.getService()));
            }
            try (InputStream is = conn.getInputStream();){
                reply = (RemoteMessage)this._serializer.deserialize(is, RemoteMessage.class);
            }
        }
        return reply;
    }

    private void setupAuthentication(HttpURLConnection conn) {
        if (this._properties.getProperty(AUTH_USERNAME) != null) {
            conn.setRequestProperty("Authorization", "Basic " + Base64.encodeFromString((String)(this._properties.getProperty(AUTH_USERNAME) + ":" + this._properties.getProperty(AUTH_PASSWORD))));
        }
        Object wsse = null;
        if (this._properties.get(WS_SECURITY_QNAME) != null) {
            wsse = this._properties.get(WS_SECURITY_QNAME);
        } else if (this._properties.get(WS_SECURITY_QNAME.toString()) != null) {
            wsse = this._properties.get(WS_SECURITY_QNAME.toString());
        } else if (this._properties.get(WS_SECURITY) != null) {
            wsse = this._properties.get(WS_SECURITY);
        }
        if (wsse != null) {
            if (wsse instanceof Node) {
                Node wsseNode = (Node)Node.class.cast(wsse);
                StringWriter sw = new StringWriter();
                try {
                    Transformer tr = TransformerFactory.newInstance().newTransformer();
                    tr.transform(new DOMSource(wsseNode), new StreamResult(sw));
                }
                catch (Exception e) {
                    throw RemoteMessages.MESSAGES.invalidWebServiceSecurityHeader(wsse, e);
                }
                wsse = sw.toString();
            } else if (!(wsse instanceof String)) {
                throw RemoteMessages.MESSAGES.unsupportedWebServiceSecurityHeaderType(wsse.getClass().getName());
            }
            conn.setRequestProperty(WS_SECURITY_HEADER, Base64.encodeFromString((String)wsse.toString()));
        }
    }

    public HttpInvoker setProperty(Object key, Object value) {
        this._properties.put(key, value);
        return this;
    }
}

