/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.rhq.plugin;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.switchyard.rhq.plugin.SwitchYardResourceComponent;
import org.switchyard.rhq.plugin.model.Application;

public class ApplicationDiscoveryComponent
implements ResourceDiscoveryComponent<SwitchYardResourceComponent> {
    private static Log LOG = LogFactory.getLog(ApplicationDiscoveryComponent.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<SwitchYardResourceComponent> context) {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        SwitchYardResourceComponent parent = (SwitchYardResourceComponent)context.getParentResourceComponent();
        Map<String, Application> applications = parent.getApplications();
        if (applications != null) {
            for (Application application : applications.values()) {
                Configuration pluginConfig = context.getDefaultPluginConfiguration();
                QName name = application.getName();
                DiscoveredResourceDetails resource = new DiscoveredResourceDetails(context.getResourceType(), name.toString(), name.getLocalPart(), name.getNamespaceURI(), null, pluginConfig, null);
                discoveredResources.add(resource);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Discovered SwitchYard Application " + application));
            }
        }
        return discoveredResources;
    }
}

