/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.rhq.plugin;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.ManagedASComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.switchyard.rhq.plugin.ApplicationResourceComponent;
import org.switchyard.rhq.plugin.BaseSwitchYardResourceComponent;
import org.switchyard.rhq.plugin.SwitchYardResourceComponent;
import org.switchyard.rhq.plugin.model.Application;
import org.switchyard.rhq.plugin.model.ComponentReference;
import org.switchyard.rhq.plugin.model.ComponentReferenceMetrics;
import org.switchyard.rhq.plugin.model.ComponentService;
import org.switchyard.rhq.plugin.model.ComponentServiceMetrics;
import org.switchyard.rhq.plugin.model.OperationMetrics;
import org.switchyard.rhq.plugin.operations.ResetComponentServiceMetrics;

public class ComponentServiceResourceComponent
extends BaseSwitchYardResourceComponent<ApplicationResourceComponent>
implements MeasurementFacet,
OperationFacet {
    private static Log LOG = LogFactory.getLog(ComponentServiceResourceComponent.class);

    @Override
    protected Log getLog() {
        return LOG;
    }

    public AvailabilityType getAvailability() {
        ComponentService componentService = this.getComponentService();
        return componentService == null ? AvailabilityType.DOWN : AvailabilityType.UP;
    }

    public Map<String, ComponentReference> getReferences() {
        ComponentService componentService = this.getComponentService();
        if (componentService == null) {
            return Collections.emptyMap();
        }
        return componentService.getReferences();
    }

    public ComponentService getComponentService() {
        String componentServiceKey = this.getResourceContext().getResourceKey();
        return this.getApplication().getComponentServices().get(componentServiceKey);
    }

    public Application getApplication() {
        return ((ApplicationResourceComponent)this.getResourceContext().getParentResourceComponent()).getApplication();
    }

    public <T> T execute(Operation operation, Class<T> clazz) {
        return ((ApplicationResourceComponent)this.getResourceContext().getParentResourceComponent()).execute(operation, clazz);
    }

    private ComponentServiceMetrics getComponentServiceMetrics() {
        String componentServiceKey = this.getResourceContext().getResourceKey();
        Map<String, ComponentServiceMetrics> componentServiceMetrics = ((ApplicationResourceComponent)this.getResourceContext().getParentResourceComponent()).getComponentServiceMetrics();
        return componentServiceMetrics != null ? componentServiceMetrics.get(componentServiceKey) : null;
    }

    public Map<String, OperationMetrics> getOperationMetrics() {
        ComponentServiceMetrics componentServiceMetrics = this.getComponentServiceMetrics();
        if (componentServiceMetrics != null) {
            return componentServiceMetrics.getOperationMetrics();
        }
        return Collections.emptyMap();
    }

    public Map<String, ComponentReferenceMetrics> getComponentReferenceMetrics() {
        ComponentServiceMetrics componentServiceMetrics = this.getComponentServiceMetrics();
        if (componentServiceMetrics != null) {
            return componentServiceMetrics.getComponentReferenceMetrics();
        }
        return Collections.emptyMap();
    }

    public void clearComponentServiceMetrics() {
        ((ApplicationResourceComponent)this.getResourceContext().getParentResourceComponent()).clearComponentServiceMetrics();
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        ComponentServiceMetrics metrics = this.getComponentServiceMetrics();
        if (metrics != null) {
            for (MeasurementScheduleRequest request : requests) {
                MeasurementDataNumeric measurementData = this.getCommonMetric(request, metrics);
                if (measurementData != null) {
                    report.addData(measurementData);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Unable to collect Component Service measurement " + request.getName()));
            }
        }
    }

    private Address getAddress() {
        SwitchYardResourceComponent src;
        ApplicationResourceComponent arc = (ApplicationResourceComponent)this.getResourceContext().getParentResourceComponent();
        BaseComponent component = null;
        if (arc != null && arc.getResourceContext() != null && arc.getResourceContext().getParentResourceComponent() != null && (src = (SwitchYardResourceComponent)arc.getResourceContext().getParentResourceComponent()) != null && src.getResourceContext() != null && src.getResourceContext().getParentResourceComponent() != null) {
            component = (BaseComponent)src.getResourceContext().getParentResourceComponent();
        }
        String parentPath = null;
        if (component != null) {
            parentPath = component.getPath();
        }
        if (parentPath == null || parentPath.isEmpty()) {
            parentPath = "";
        }
        String path = parentPath;
        if (component instanceof ManagedASComponent) {
            if (path.startsWith("host=")) {
                path = path.replaceAll(",server-config=", ",server=");
                parentPath = parentPath.replaceAll(",server-config=", ",server=");
                Address addr = new Address(parentPath + ",subsystem=switchyard");
                return addr;
            }
            return null;
        }
        return null;
    }

    private Operation getResetComponentServiceMetrics(String applicationName, String componentServiceName) {
        ResetComponentServiceMetrics operation = new ResetComponentServiceMetrics(applicationName, componentServiceName);
        Address addr = this.getAddress();
        if (addr != null) {
            operation = new Operation("reset-metrics", addr);
            operation.addAdditionalProperty("application-name", applicationName);
            operation.addAdditionalProperty("name", componentServiceName);
            operation.addAdditionalProperty("type", "componentService");
        }
        return operation;
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if ("reset".equals(name)) {
            ComponentService componentService = this.getComponentService();
            Application application = this.getApplication();
            if (componentService != null && application != null) {
                String componentServiceName = componentService.getName().toString();
                String applicationName = application.getName().toString();
                this.execute(this.getResetComponentServiceMetrics(applicationName, componentServiceName), Void.class);
                this.clearComponentServiceMetrics();
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.warn((Object)("Unknown Component Service operation " + name));
        }
        return null;
    }
}

