/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.rhq.plugin;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.switchyard.rhq.plugin.BaseSwitchYardResourceComponent;
import org.switchyard.rhq.plugin.ReferenceResourceComponent;
import org.switchyard.rhq.plugin.model.OperationMetrics;

public class ReferenceOperationResourceComponent
extends BaseSwitchYardResourceComponent<ReferenceResourceComponent>
implements MeasurementFacet {
    private static Log LOG = LogFactory.getLog(ReferenceOperationResourceComponent.class);

    @Override
    protected Log getLog() {
        return LOG;
    }

    public AvailabilityType getAvailability() {
        OperationMetrics metrics = this.getOperationMetrics();
        return metrics == null ? AvailabilityType.DOWN : AvailabilityType.UP;
    }

    public OperationMetrics getOperationMetrics() {
        String operationKey = this.getResourceContext().getResourceKey();
        return ((ReferenceResourceComponent)this.getResourceContext().getParentResourceComponent()).getOperationMetrics().get(operationKey);
    }

    public <T> T execute(Operation operation, Class<T> clazz) {
        return ((ReferenceResourceComponent)this.getResourceContext().getParentResourceComponent()).execute(operation, clazz);
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        OperationMetrics metrics = this.getOperationMetrics();
        if (metrics != null) {
            for (MeasurementScheduleRequest request : requests) {
                MeasurementDataNumeric measurementData = this.getCommonMetric(request, metrics);
                if (measurementData != null) {
                    report.addData(measurementData);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Unable to collect Reference Operation measurement " + request.getName()));
            }
        }
    }
}

