/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.rhq.plugin;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.ManagedASComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.switchyard.rhq.plugin.model.GetVersionResult;
import org.switchyard.rhq.plugin.operations.GetVersion;

public class SwitchYardDiscoveryComponent
implements ResourceDiscoveryComponent<BaseComponent<?>> {
    private static final Log LOG = LogFactory.getLog(SwitchYardDiscoveryComponent.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Pattern CONF_PATH_PATTERN = Pattern.compile("\\|");

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<BaseComponent<?>> context) {
        GetVersionResult result;
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        BaseComponent parentComponent = (BaseComponent)context.getParentResourceComponent();
        Configuration config = context.getDefaultPluginConfiguration();
        String parentPath = parentComponent.getPath();
        if (parentPath == null || parentPath.isEmpty()) {
            parentPath = "";
        }
        String path = parentPath;
        GetVersion operation = new GetVersion();
        if (parentComponent instanceof ManagedASComponent && path.startsWith("host=")) {
            path = path.replaceAll(",server-config=", ",server=");
            parentPath = parentPath.replaceAll(",server-config=", ",server=");
            Address addr = new Address(parentPath + ",subsystem=switchyard");
            operation = new Operation("get-version", addr);
        }
        if ((result = SwitchYardDiscoveryComponent.execute((BaseComponent)context.getParentResourceComponent(), operation, GetVersionResult.class)) != null) {
            Configuration pluginConfig = context.getDefaultPluginConfiguration();
            DiscoveredResourceDetails resource = new DiscoveredResourceDetails(context.getResourceType(), "SwitchYardSubsystem", "SwitchYard", result.getVersion(), "Container for SwitchYard Applications", pluginConfig, null);
            discoveredResources.add(resource);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Discovered SwitchYard subsystem for " + context.getPluginContainerName()));
            }
        }
        return discoveredResources;
    }

    public static <T> T execute(BaseComponent<?> server, Operation operation, Class<T> clazz) {
        Object response;
        ASConnection asConnection = server.getASConnection();
        JsonNode jsonNode = asConnection.executeRaw(operation);
        if (jsonNode == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Receiver null response to operation " + operation));
            }
            return null;
        }
        JsonNode outcome = jsonNode.findValue("outcome");
        if (outcome == null || !"success".equals(outcome.asText())) {
            if (LOG.isDebugEnabled()) {
                JsonNode failureDescription = jsonNode.findValue("failure-description");
                if (failureDescription != null) {
                    LOG.debug((Object)("Invocation failed for operation " + operation + ": " + failureDescription.asText()));
                } else {
                    LOG.debug((Object)("Invocation failed for operation " + operation));
                }
            }
            return null;
        }
        JsonNode result = jsonNode.findValue("result");
        if (result == null) {
            return null;
        }
        try {
            response = mapper.readValue(result, clazz);
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failure during deserialisation of operation " + operation), (Throwable)ex);
            }
            return null;
        }
        return (T)response;
    }
}

