/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.rhq.plugin;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.BaseServerComponent;
import org.rhq.modules.plugins.jbossas7.ManagedASComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.switchyard.rhq.plugin.BaseSwitchYardResourceComponent;
import org.switchyard.rhq.plugin.SwitchYardDiscoveryComponent;
import org.switchyard.rhq.plugin.model.Application;
import org.switchyard.rhq.plugin.model.ApplicationNamedMetric;
import org.switchyard.rhq.plugin.model.ComponentServiceMetrics;
import org.switchyard.rhq.plugin.model.ModelUtil;
import org.switchyard.rhq.plugin.model.NamedResource;
import org.switchyard.rhq.plugin.model.ReferenceMetrics;
import org.switchyard.rhq.plugin.model.ServiceMetrics;
import org.switchyard.rhq.plugin.model.SwitchYardMetrics;
import org.switchyard.rhq.plugin.operations.ReadApplication;
import org.switchyard.rhq.plugin.operations.ReadComponentServiceMetrics;
import org.switchyard.rhq.plugin.operations.ReadReferenceMetrics;
import org.switchyard.rhq.plugin.operations.ReadServiceMetrics;
import org.switchyard.rhq.plugin.operations.ReadSwitchYardMetrics;
import org.switchyard.rhq.plugin.operations.ResetMetrics;

public class SwitchYardResourceComponent
extends BaseSwitchYardResourceComponent<BaseServerComponent<?>>
implements MeasurementFacet,
OperationFacet {
    private static Log LOG = LogFactory.getLog(SwitchYardResourceComponent.class);
    private static long REFRESH = 30000L;
    private AtomicReference<Map<String, Application>> applications = new AtomicReference();
    private AtomicLong applicationTimestamp = new AtomicLong();
    private AtomicReference<SwitchYardMetrics> switchYardMetrics = new AtomicReference();
    private AtomicLong switchYardMetricsTimestamp = new AtomicLong();
    private AtomicReference<Map<String, Map<String, ServiceMetrics>>> serviceMetrics = new AtomicReference();
    private AtomicLong serviceMetricsTimestamp = new AtomicLong();
    private AtomicReference<Map<String, Map<String, ReferenceMetrics>>> referenceMetrics = new AtomicReference();
    private AtomicLong referenceMetricsTimestamp = new AtomicLong();
    private AtomicReference<Map<String, Map<String, ComponentServiceMetrics>>> componentServiceMetrics = new AtomicReference();
    private AtomicLong componentServiceMetricsTimestamp = new AtomicLong();

    public AvailabilityType getAvailability() {
        SwitchYardMetrics metrics = this.getSwitchYardMetrics();
        return metrics == null ? AvailabilityType.DOWN : AvailabilityType.UP;
    }

    @Override
    protected Log getLog() {
        return LOG;
    }

    public <T> T execute(Operation operation, Class<T> clazz) {
        return SwitchYardDiscoveryComponent.execute((BaseComponent)this.getResourceContext().getParentResourceComponent(), operation, clazz);
    }

    public Map<String, Application> getApplications() {
        return this.getApplicationMap();
    }

    public Application getApplication(String name) {
        return this.getApplicationMap().get(name);
    }

    public SwitchYardMetrics getSwitchYardMetrics() {
        return this.getCachedSwitchYardMetrics();
    }

    public Map<String, Map<String, ServiceMetrics>> getServiceMetrics() {
        return this.getCachedServiceMetrics();
    }

    public Map<String, Map<String, ReferenceMetrics>> getReferenceMetrics() {
        return this.getCachedReferenceMetrics();
    }

    public Map<String, Map<String, ComponentServiceMetrics>> getComponentServiceMetrics() {
        return this.getCachedComponentServiceMetrics();
    }

    public void clearApplications() {
        this.applicationTimestamp.set(0L);
    }

    public void clearServiceMetrics() {
        this.serviceMetricsTimestamp.set(0L);
    }

    public void clearReferenceMetrics() {
        this.referenceMetricsTimestamp.set(0L);
    }

    public void clearComponentServiceMetrics() {
        this.componentServiceMetricsTimestamp.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Application> getApplicationMap() {
        Map<String, Application> applicationMap = this.applications.get();
        long now = System.currentTimeMillis();
        if (now - this.applicationTimestamp.get() > REFRESH) {
            SwitchYardResourceComponent switchYardResourceComponent = this;
            synchronized (switchYardResourceComponent) {
                if (now - this.applicationTimestamp.get() > REFRESH) {
                    applicationMap = ModelUtil.createNamedResourceMap((NamedResource[])this.loadApplications());
                    this.applications.set(applicationMap);
                    this.applicationTimestamp.set(System.currentTimeMillis());
                }
            }
            applicationMap = this.applications.get();
        }
        return applicationMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SwitchYardMetrics getCachedSwitchYardMetrics() {
        SwitchYardMetrics metrics = this.switchYardMetrics.get();
        long now = System.currentTimeMillis();
        if (now - this.switchYardMetricsTimestamp.get() > REFRESH) {
            SwitchYardResourceComponent switchYardResourceComponent = this;
            synchronized (switchYardResourceComponent) {
                if (now - this.switchYardMetricsTimestamp.get() > REFRESH && (metrics = this.loadSwitchYardMetrics()) != null) {
                    this.switchYardMetrics.set(metrics);
                    this.switchYardMetricsTimestamp.set(System.currentTimeMillis());
                }
            }
            metrics = this.switchYardMetrics.get();
        }
        return metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, ServiceMetrics>> getCachedServiceMetrics() {
        Map<String, Map<String, ServiceMetrics>> serviceMetricsMap = this.serviceMetrics.get();
        long now = System.currentTimeMillis();
        if (now - this.serviceMetricsTimestamp.get() > REFRESH) {
            SwitchYardResourceComponent switchYardResourceComponent = this;
            synchronized (switchYardResourceComponent) {
                if (now - this.serviceMetricsTimestamp.get() > REFRESH) {
                    serviceMetricsMap = ModelUtil.createApplicationNamedMetricMap((ApplicationNamedMetric[])this.loadServiceMetrics());
                    this.serviceMetrics.set(serviceMetricsMap);
                    this.serviceMetricsTimestamp.set(System.currentTimeMillis());
                }
            }
            serviceMetricsMap = this.serviceMetrics.get();
        }
        return serviceMetricsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, ReferenceMetrics>> getCachedReferenceMetrics() {
        Map<String, Map<String, ReferenceMetrics>> referenceMetricsMap = this.referenceMetrics.get();
        long now = System.currentTimeMillis();
        if (now - this.referenceMetricsTimestamp.get() > REFRESH) {
            SwitchYardResourceComponent switchYardResourceComponent = this;
            synchronized (switchYardResourceComponent) {
                if (now - this.referenceMetricsTimestamp.get() > REFRESH) {
                    referenceMetricsMap = ModelUtil.createApplicationNamedMetricMap((ApplicationNamedMetric[])this.loadReferenceMetrics());
                    this.referenceMetrics.set(referenceMetricsMap);
                    this.referenceMetricsTimestamp.set(System.currentTimeMillis());
                }
            }
            referenceMetricsMap = this.referenceMetrics.get();
        }
        return referenceMetricsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Map<String, ComponentServiceMetrics>> getCachedComponentServiceMetrics() {
        Map<String, Map<String, ComponentServiceMetrics>> componentServiceMetricsMap = this.componentServiceMetrics.get();
        long now = System.currentTimeMillis();
        if (now - this.componentServiceMetricsTimestamp.get() > REFRESH) {
            SwitchYardResourceComponent switchYardResourceComponent = this;
            synchronized (switchYardResourceComponent) {
                if (now - this.componentServiceMetricsTimestamp.get() > REFRESH) {
                    componentServiceMetricsMap = ModelUtil.createApplicationNamedMetricMap((ApplicationNamedMetric[])this.loadComponentServiceMetrics());
                    this.componentServiceMetrics.set(componentServiceMetricsMap);
                    this.componentServiceMetricsTimestamp.set(System.currentTimeMillis());
                }
            }
            componentServiceMetricsMap = this.componentServiceMetrics.get();
        }
        return componentServiceMetricsMap;
    }

    private Application[] loadApplications() {
        Application[] applications = this.execute(this.getReadApplication(), Application[].class);
        return applications == null ? new Application[]{} : applications;
    }

    public Address getAddress() {
        BaseComponent component = (BaseComponent)this.getResourceContext().getParentResourceComponent();
        String parentPath = component.getPath();
        if (parentPath == null || parentPath.isEmpty()) {
            parentPath = "";
        }
        String path = parentPath;
        if (component instanceof ManagedASComponent) {
            if (path.startsWith("host=")) {
                path = path.replaceAll(",server-config=", ",server=");
                parentPath = parentPath.replaceAll(",server-config=", ",server=");
                Address addr = new Address(parentPath + ",subsystem=switchyard");
                return addr;
            }
            return null;
        }
        return null;
    }

    public Operation getReadApplication() {
        ReadApplication operation = new ReadApplication();
        Address addr = this.getAddress();
        if (addr != null) {
            operation = new Operation("read-application", addr);
        }
        return operation;
    }

    public Operation getReadSwitchYardMetrics() {
        ReadSwitchYardMetrics operation = new ReadSwitchYardMetrics();
        Address addr = this.getAddress();
        if (addr != null) {
            operation = new Operation("show-metrics", addr);
        }
        return operation;
    }

    public Operation getReadServiceMetrics() {
        ReadServiceMetrics operation = new ReadServiceMetrics();
        Address addr = this.getAddress();
        if (addr != null) {
            operation = new Operation("show-metrics", addr);
        }
        operation.addAdditionalProperty("type", "service");
        operation.addAdditionalProperty("service-name", "*");
        return operation;
    }

    public Operation getReadReferenceMetrics() {
        ReadReferenceMetrics operation = new ReadReferenceMetrics();
        Address addr = this.getAddress();
        if (addr != null) {
            operation = new Operation("show-metrics", addr);
        }
        operation.addAdditionalProperty("type", "reference");
        operation.addAdditionalProperty("service-name", "*");
        return operation;
    }

    public Operation getReadComponentServiceMetrics() {
        ReadComponentServiceMetrics operation = new ReadComponentServiceMetrics();
        Address addr = this.getAddress();
        if (addr != null) {
            operation = new Operation("show-metrics", addr);
        }
        operation.addAdditionalProperty("type", "componentService");
        operation.addAdditionalProperty("service-name", "*");
        return operation;
    }

    private SwitchYardMetrics loadSwitchYardMetrics() {
        SwitchYardMetrics[] metrics = this.execute(this.getReadSwitchYardMetrics(), SwitchYardMetrics[].class);
        return metrics == null ? null : metrics[0];
    }

    private ServiceMetrics[] loadServiceMetrics() {
        ServiceMetrics[] serviceMetrics = this.execute(this.getReadServiceMetrics(), ServiceMetrics[].class);
        return serviceMetrics == null ? new ServiceMetrics[]{} : serviceMetrics;
    }

    private ReferenceMetrics[] loadReferenceMetrics() {
        ReferenceMetrics[] referenceMetrics = this.execute(this.getReadReferenceMetrics(), ReferenceMetrics[].class);
        return referenceMetrics == null ? new ReferenceMetrics[]{} : referenceMetrics;
    }

    private ComponentServiceMetrics[] loadComponentServiceMetrics() {
        ComponentServiceMetrics[] componentServiceMetrics = this.execute(this.getReadComponentServiceMetrics(), ComponentServiceMetrics[].class);
        return componentServiceMetrics == null ? new ComponentServiceMetrics[]{} : componentServiceMetrics;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        SwitchYardMetrics metrics = this.getSwitchYardMetrics();
        if (metrics != null) {
            for (MeasurementScheduleRequest request : requests) {
                MeasurementDataNumeric measurementData = this.getCommonMetric(request, metrics);
                if (measurementData != null) {
                    report.addData(measurementData);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Unable to collect SwitchYard measurement " + request.getName()));
            }
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        if ("reset".equals(name)) {
            this.execute(new ResetMetrics(), Void.class);
            this.clearServiceMetrics();
            this.clearReferenceMetrics();
            this.clearComponentServiceMetrics();
        } else if (LOG.isDebugEnabled()) {
            LOG.warn((Object)("Unknown SwitchYard operation " + name));
        }
        return null;
    }
}

