/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.handlers.HandlerChain;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.transform.TransformSequence;

public class DefaultHandlerChain
implements HandlerChain {
    private final Logger _logger = Logger.getLogger((String)DefaultHandlerChain.class.toString());
    private final LinkedList<HandlerRef> _chain = new LinkedList();

    public DefaultHandlerChain() {
    }

    private DefaultHandlerChain(List<HandlerRef> handlers) {
        this._chain.addAll(handlers);
    }

    @Override
    public synchronized void addFirst(String handlerName, ExchangeHandler handler) {
        this._chain.addFirst(new HandlerRef(handlerName, handler));
    }

    @Override
    public synchronized void addLast(String handlerName, ExchangeHandler handler) {
        this._chain.addLast(new HandlerRef(handlerName, handler));
    }

    @Override
    public synchronized ExchangeHandler remove(String handlerName) {
        ExchangeHandler handler = null;
        for (HandlerRef ref : this._chain) {
            if (!ref.getName().equals(handlerName)) continue;
            handler = ref.getHandler();
            this._chain.remove(ref);
            break;
        }
        return handler;
    }

    @Override
    public void handle(Exchange exchange) {
        if (exchange.getState() == ExchangeState.FAULT) {
            this.handleFault(exchange);
        } else {
            this.handleMessage(exchange);
        }
    }

    public void handleFault(Exchange exchange) {
        try {
            for (HandlerRef ref : this.listHandlers()) {
                ref.getHandler().handleFault(exchange);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to recover from fault on", e);
        }
    }

    public void handleMessage(Exchange exchange) {
        try {
            for (HandlerRef ref : this.listHandlers()) {
                ref.getHandler().handleMessage(exchange);
                if (exchange.getState() != ExchangeState.FAULT) continue;
                break;
            }
        }
        catch (HandlerException handlerEx) {
            this._logger.error((Object)handlerEx);
            Message faultMessage = exchange.createMessage().setContent((Object)handlerEx);
            this.initFaultTransformsequence(exchange, handlerEx, faultMessage);
            exchange.sendFault(faultMessage);
        }
    }

    private void initFaultTransformsequence(Exchange exchange, HandlerException handlerEx, Message faultMessage) {
        ExchangeContract contract = exchange.getContract();
        QName exceptionTypeName = contract.getServiceOperation().getFaultType();
        QName invokerFaultTypeName = contract.getInvokerInvocationMetaData().getFaultType();
        if (exceptionTypeName == null) {
            exceptionTypeName = JavaService.toMessageType(((Object)((Object)handlerEx)).getClass());
        }
        if (exceptionTypeName != null && invokerFaultTypeName != null) {
            TransformSequence.from((QName)exceptionTypeName).to(invokerFaultTypeName).associateWith(faultMessage.getContext());
        }
    }

    public DefaultHandlerChain copy() {
        return new DefaultHandlerChain(this.listHandlers());
    }

    private synchronized List<HandlerRef> listHandlers() {
        return new LinkedList<HandlerRef>(this._chain);
    }

    private class HandlerRef {
        private final ExchangeHandler _handler;
        private final String _name;

        HandlerRef(String name, ExchangeHandler handler) {
            this._handler = handler;
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public ExchangeHandler getHandler() {
            return this._handler;
        }
    }
}

