/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.internal.ServiceRegistration;
import org.switchyard.spi.Dispatcher;
import org.switchyard.spi.Service;
import org.switchyard.spi.ServiceRegistry;

public class DefaultServiceRegistry
implements ServiceRegistry {
    private final Map<QName, List<Service>> _services = new HashMap<QName, List<Service>>();

    @Override
    public List<Service> getServicesForDomain(QName domainName) {
        List<Service> domainServices = this.getServices();
        Iterator<Service> i = domainServices.iterator();
        while (i.hasNext()) {
            ServiceRegistration sr = (ServiceRegistration)i.next();
            if (sr.getDomain().getName().equals(domainName)) continue;
            i.remove();
        }
        return domainServices;
    }

    @Override
    public synchronized List<Service> getServices() {
        LinkedList<Service> serviceList = new LinkedList<Service>();
        for (List<Service> services : this._services.values()) {
            serviceList.addAll(services);
        }
        return serviceList;
    }

    @Override
    public synchronized List<Service> getServices(QName serviceName) {
        List<Service> services = this._services.get(serviceName);
        if (services == null) {
            return Collections.emptyList();
        }
        return new LinkedList<Service>(services);
    }

    @Override
    public synchronized Service registerService(ServiceReference reference, Dispatcher endpoint, ServiceDomain domain) {
        ServiceRegistration sr = new ServiceRegistration(reference, endpoint, this, domain);
        List<Service> serviceList = this._services.get(reference.getName());
        if (serviceList == null) {
            serviceList = new LinkedList<Service>();
            this._services.put(reference.getName(), serviceList);
        }
        serviceList.add(sr);
        return sr;
    }

    @Override
    public synchronized void unregisterService(Service service) {
        List<Service> serviceList = this._services.get(service.getReference().getName());
        if (serviceList != null) {
            serviceList.remove(service);
        }
    }
}

