/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerChain;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.handlers.PolicyHandler;
import org.switchyard.handlers.TransactionHandler;
import org.switchyard.handlers.TransformHandler;
import org.switchyard.internal.DefaultHandlerChain;
import org.switchyard.internal.ExchangeImpl;
import org.switchyard.internal.ServiceReferenceImpl;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.InOutService;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.policy.Policy;
import org.switchyard.spi.Dispatcher;
import org.switchyard.spi.ExchangeBus;
import org.switchyard.spi.Service;
import org.switchyard.spi.ServiceRegistry;
import org.switchyard.transform.TransformerRegistry;

public class DomainImpl
implements ServiceDomain {
    private static Logger _logger = Logger.getLogger(DomainImpl.class);
    private final QName _name;
    private final DefaultHandlerChain _defaultHandlers;
    private final ServiceRegistry _registry;
    private final ExchangeBus _exchangeBus;
    private final TransformerRegistry _transformerRegistry;

    public DomainImpl(QName name, ServiceRegistry registry, ExchangeBus exchangeBus, TransformerRegistry transformerRegistry) {
        this._name = name;
        this._registry = registry;
        this._exchangeBus = exchangeBus;
        this._transformerRegistry = transformerRegistry;
        TransactionHandler transactionHandler = new TransactionHandler();
        this._defaultHandlers = new DefaultHandlerChain();
        this._defaultHandlers.addLast("transaction-pre-invoke", transactionHandler);
        this._defaultHandlers.addLast("generic-policy", new PolicyHandler());
        this._defaultHandlers.addLast("transformation", (ExchangeHandler)new TransformHandler(this._transformerRegistry));
        this._defaultHandlers.addLast("provider", (ExchangeHandler)new BaseHandler());
        this._defaultHandlers.addLast("transaction-post-invoke", transactionHandler);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Created SwitchYard ServiceDomain instance '" + name + "'."));
        }
    }

    public Exchange createExchange(ServiceReference service, ExchangeContract contract) {
        return this.createExchange(service, contract, null);
    }

    public Exchange createExchange(ServiceReference service, ExchangeContract contract, ExchangeHandler handler) {
        Dispatcher dispatcher = this._exchangeBus.getDispatcher(service);
        DefaultHandlerChain replyChain = null;
        if (handler != null) {
            replyChain = this._defaultHandlers.copy();
            replyChain.addLast("replyHandler", handler);
        }
        ExchangeImpl exchange = new ExchangeImpl(service.getName(), contract, dispatcher, this._transformerRegistry, replyChain);
        return exchange;
    }

    public ServiceReference registerService(QName serviceName, ExchangeHandler handler) {
        return this.registerService(serviceName, handler, null);
    }

    public ServiceReference registerService(QName serviceName, ExchangeHandler handler, ServiceInterface metadata, List<Policy> requires) {
        if (metadata == null) {
            metadata = new InOutService();
        }
        ServiceReferenceImpl reference = new ServiceReferenceImpl(serviceName, metadata, requires, this);
        DefaultHandlerChain handlers = this._defaultHandlers.copy();
        handlers.replace("provider", handler);
        Dispatcher ep = this._exchangeBus.createDispatcher(reference, handlers, this._transformerRegistry);
        return this._registry.registerService(reference, ep, this).getReference();
    }

    public ServiceReference registerService(QName serviceName, ExchangeHandler handler, ServiceInterface metadata) {
        List<Policy> requires = Collections.emptyList();
        return this.registerService(serviceName, handler, metadata, requires);
    }

    public QName getName() {
        return this._name;
    }

    public TransformerRegistry getTransformerRegistry() {
        return this._transformerRegistry;
    }

    public ServiceReference getService(QName serviceName) {
        List<Service> services = this._registry.getServices(serviceName);
        return services.isEmpty() ? null : services.get(0).getReference();
    }

    public HandlerChain getHandlerChain() {
        return this._defaultHandlers;
    }
}

