/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.policy.ExchangePolicy;
import org.switchyard.policy.Policy;

public class ServiceReferenceImpl
implements ServiceReference {
    private QName _name;
    private ServiceInterface _interface;
    private ServiceDomain _domain;
    private List<Policy> _requires;

    public ServiceReferenceImpl(QName name, ServiceInterface serviceInterface, List<Policy> requires, ServiceDomain domain) {
        this._name = name;
        this._interface = serviceInterface;
        this._domain = domain;
        this._requires = requires != null ? requires : Collections.emptyList();
    }

    public Exchange createExchange(ExchangeContract contract) {
        Exchange ex = this._domain.createExchange((ServiceReference)this, contract);
        for (Policy policy : this._requires) {
            ExchangePolicy.require((Exchange)ex, (Policy)policy);
        }
        return ex;
    }

    public Exchange createExchange(ExchangeContract contract, ExchangeHandler handler) {
        Exchange ex = this._domain.createExchange((ServiceReference)this, contract, handler);
        for (Policy policy : this._requires) {
            ExchangePolicy.require((Exchange)ex, (Policy)policy);
        }
        return ex;
    }

    public ServiceInterface getInterface() {
        return this._interface;
    }

    public QName getName() {
        return this._name;
    }

    public ServiceDomain getDomain() {
        return this._domain;
    }
}

