/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.MockExchange;
import org.switchyard.handlers.PolicyHandler;
import org.switchyard.internal.DefaultContext;
import org.switchyard.policy.ExchangePolicy;
import org.switchyard.policy.Policy;

public class PolicyHandlerTest {
    static final String FOO_POLICY_NAME = "foo";
    static final String BAR_POLICY_NAME = "bar";
    private MockExchange exchange;
    private PolicyHandler handler;

    @Before
    public void setUp() {
        this.exchange = new MockExchange();
        this.exchange.setContext((Context)new DefaultContext());
        this.handler = new PolicyHandler();
    }

    @Test
    public void requiredButNotProvided() {
        ExchangePolicy.require((Exchange)this.exchange, (Policy)new FooPolicy());
        ExchangePolicy.require((Exchange)this.exchange, (Policy)new BarPolicy());
        ExchangePolicy.provide((Exchange)this.exchange, (Policy)new BarPolicy());
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            System.out.println(handlerEx.toString());
            return;
        }
        Assert.fail((String)"Expected a handler exception due to incompatible policy");
    }

    @Test
    public void providedButNotRequired() {
        ExchangePolicy.provide((Exchange)this.exchange, (Policy)new FooPolicy());
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            Assert.fail((String)("Exception not expected when policy is provided but not required: " + (Object)((Object)handlerEx)));
        }
    }

    @Test
    public void requiredAndProvided() {
        ExchangePolicy.require((Exchange)this.exchange, (Policy)new FooPolicy());
        ExchangePolicy.provide((Exchange)this.exchange, (Policy)new FooPolicy());
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            Assert.fail((String)("Exception not expected, required policy is provided: " + (Object)((Object)handlerEx)));
        }
    }

    class BarPolicy
    implements Policy {
        BarPolicy() {
        }

        public String getName() {
            return PolicyHandlerTest.BAR_POLICY_NAME;
        }
    }

    class FooPolicy
    implements Policy {
        FooPolicy() {
        }

        public String getName() {
            return PolicyHandlerTest.FOO_POLICY_NAME;
        }
    }
}

