/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import javax.transaction.TransactionManager;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.MockExchange;
import org.switchyard.handlers.MockTransactionManager;
import org.switchyard.handlers.TransactionHandler;
import org.switchyard.internal.DefaultContext;
import org.switchyard.policy.ExchangePolicy;
import org.switchyard.policy.Policy;
import org.switchyard.policy.TransactionPolicy;

public class TransactionHandlerTest {
    private MockTransactionManager tm;
    private MockExchange exchange;
    private TransactionHandler handler;

    @Before
    public void setUp() {
        this.tm = new MockTransactionManager();
        this.exchange = new MockExchange();
        this.exchange.setContext((Context)new DefaultContext());
        this.handler = new TransactionHandler();
        this.handler.setTransactionManager((TransactionManager)this.tm);
    }

    @Test
    public void incompatibleRequirements() {
        ExchangePolicy.require((Exchange)this.exchange, (Policy)TransactionPolicy.PROPAGATE);
        ExchangePolicy.require((Exchange)this.exchange, (Policy)TransactionPolicy.SUSPEND);
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            System.out.println(handlerEx.toString());
            return;
        }
        Assert.fail((String)"Expected a handler exception due to incompatible policy");
    }

    @Test
    public void propagateProvidedButNotRequired() {
        ExchangePolicy.provide((Exchange)this.exchange, (Policy)TransactionPolicy.PROPAGATE);
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            Assert.fail((String)("Exception not expected when transaction is provided but not required: " + (Object)((Object)handlerEx)));
        }
    }

    @Test
    public void propagateRequiredButNotProvided() {
        ExchangePolicy.require((Exchange)this.exchange, (Policy)TransactionPolicy.PROPAGATE);
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            System.out.println(handlerEx.toString());
            return;
        }
        Assert.fail((String)"Handler should fail when propagation required, but not provided");
    }

    @Test
    public void suspendTransaction() throws Exception {
        ExchangePolicy.require((Exchange)this.exchange, (Policy)TransactionPolicy.SUSPEND);
        this.exchange.setPhase(ExchangePhase.IN);
        this.handler.handleMessage((Exchange)this.exchange);
        Assert.assertFalse((boolean)this.tm.getTransaction().active);
        this.exchange.setPhase(ExchangePhase.OUT);
        this.handler.handleMessage((Exchange)this.exchange);
        Assert.assertTrue((boolean)this.tm.getTransaction().active);
    }
}

