/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.EventObject;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.Message;
import org.switchyard.MockDomain;
import org.switchyard.MockHandler;
import org.switchyard.Service;
import org.switchyard.ServiceReference;
import org.switchyard.event.EventObserver;
import org.switchyard.event.ReferenceRegistrationEvent;
import org.switchyard.internal.CountingEventObserver;
import org.switchyard.internal.CountingHandler;
import org.switchyard.internal.DefaultMessage;
import org.switchyard.internal.DefaultServiceRegistry;
import org.switchyard.internal.DomainImpl;
import org.switchyard.internal.EventManager;
import org.switchyard.internal.LocalExchangeBus;
import org.switchyard.internal.MyInterface;
import org.switchyard.metadata.InOnlyService;
import org.switchyard.metadata.InOutService;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.java.JavaService;
import org.switchyard.spi.ExchangeBus;
import org.switchyard.spi.ServiceRegistry;

public class DomainImplTest {
    private static final QName IN_ONLY_SERVICE = new QName("InOnlyService");
    private static final QName IN_OUT_SERVICE = new QName("InOutService");
    private ServiceReference _inOnlyReference;
    private ServiceReference _inOutReference;
    private DomainImpl _domain;

    @Before
    public void setUp() throws Exception {
        this._domain = new DomainImpl(new QName("test"), (ServiceRegistry)new DefaultServiceRegistry(), (ExchangeBus)new LocalExchangeBus(), null, null, new EventManager());
        this._domain.registerService(IN_ONLY_SERVICE, (ServiceInterface)new InOnlyService(), (ExchangeHandler)new MockHandler());
        this._domain.registerService(IN_OUT_SERVICE, (ServiceInterface)new InOutService(), (ExchangeHandler)new MockHandler());
        this._inOnlyReference = this._domain.registerServiceReference(IN_ONLY_SERVICE, (ServiceInterface)new InOnlyService());
        this._inOutReference = this._domain.registerServiceReference(IN_OUT_SERVICE, (ServiceInterface)new InOutService());
    }

    @Test
    public void testCreateExchange() {
        Exchange inOnly = this._inOnlyReference.createExchange();
        Assert.assertEquals((Object)ExchangePattern.IN_ONLY, (Object)inOnly.getContract().getServiceOperation().getExchangePattern());
        Exchange inOut = this._inOutReference.createExchange((ExchangeHandler)new MockHandler());
        Assert.assertEquals((Object)ExchangePattern.IN_OUT, (Object)inOut.getContract().getServiceOperation().getExchangePattern());
    }

    @Test
    public void testRegisterServiceWithoutInterface() {
        Service service = this._domain.registerService(new QName("no-interface"), null, (ExchangeHandler)new MockHandler());
        Assert.assertNotNull((Object)service.getInterface());
        Assert.assertTrue((service.getInterface().getOperations().size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)service.getInterface().getOperation(""));
    }

    @Test
    public void testRegisterServiceWithInterface() {
        Service service = this._domain.registerService(new QName("my-interface"), (ServiceInterface)JavaService.fromClass(MyInterface.class), (ExchangeHandler)new MockHandler());
        Assert.assertNotNull((Object)service.getInterface());
        Assert.assertTrue((service.getInterface().getOperations().size() == 1 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)service.getInterface().getOperation("myOperation"));
    }

    @Test
    public void testDomainHandler() throws Exception {
        MockDomain testDomain = new MockDomain();
        CountingHandler counter = new CountingHandler();
        testDomain.getHandlerChain().addFirst("counter", (ExchangeHandler)counter);
        ServiceReference inOnly = testDomain.createInOnlyService(new QName("CountIn"));
        ServiceReference inOut = testDomain.createInOutService(new QName("CountInOut"), (ExchangeHandler)new MockHandler().forwardInToOut());
        Exchange ex1 = inOnly.createExchange();
        ex1.send((Message)new DefaultMessage());
        Assert.assertEquals((int)1, (int)counter.getCount());
        counter.clear();
        Exchange ex2 = inOut.createExchange((ExchangeHandler)new MockHandler());
        ex2.send((Message)new DefaultMessage().setContent((Object)"hello"));
        Assert.assertEquals((int)2, (int)counter.getCount());
    }

    @Test
    public void testGetEventPublisher() {
        Assert.assertNotNull((Object)this._domain.getEventPublisher());
    }

    @Test
    public void testAddObserver() {
        CountingEventObserver obs = new CountingEventObserver();
        this._domain.addEventObserver((EventObserver)obs, ReferenceRegistrationEvent.class);
        this._domain.getEventPublisher().publish((EventObject)new ReferenceRegistrationEvent(this._inOnlyReference));
        Assert.assertEquals((int)1, (int)obs.count);
    }
}

