/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.BaseHandler;
import org.switchyard.ExchangeHandler;
import org.switchyard.MockDomain;
import org.switchyard.Service;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.event.EventObserver;
import org.switchyard.event.ReferenceRegistrationEvent;
import org.switchyard.event.ReferenceUnregistrationEvent;
import org.switchyard.event.ServiceRegistrationEvent;
import org.switchyard.event.ServiceUnregistrationEvent;
import org.switchyard.event.TransformerAddedEvent;
import org.switchyard.event.TransformerRemovedEvent;
import org.switchyard.event.ValidatorAddedEvent;
import org.switchyard.event.ValidatorRemovedEvent;
import org.switchyard.internal.DummyObserver;
import org.switchyard.metadata.InOutService;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.transform.BaseTransformer;
import org.switchyard.transform.Transformer;
import org.switchyard.validate.BaseValidator;
import org.switchyard.validate.Validator;

public class EventsTest {
    private ServiceDomain _domain;
    private DummyObserver _observer;

    @Before
    public void setUp() throws Exception {
        this._domain = new MockDomain();
        this._observer = new DummyObserver();
    }

    @Test
    public void testTransformerEvents() {
        this._domain.addEventObserver((EventObserver)this._observer, TransformerAddedEvent.class).addEventObserver((EventObserver)this._observer, TransformerRemovedEvent.class);
        BaseTransformer<String, String> t = new BaseTransformer<String, String>(){

            public String transform(String from) {
                return null;
            }
        };
        this._domain.getTransformerRegistry().addTransformer((Transformer)t);
        Assert.assertTrue((boolean)this._observer.addTransformerCalled);
        this._domain.getTransformerRegistry().removeTransformer((Transformer)t);
        Assert.assertTrue((boolean)this._observer.removeTransformerCalled);
    }

    @Test
    public void testValidatorEvents() {
        this._domain.addEventObserver((EventObserver)this._observer, ValidatorAddedEvent.class).addEventObserver((EventObserver)this._observer, ValidatorRemovedEvent.class);
        BaseValidator<String> t = new BaseValidator<String>(){

            public boolean validate(String name) {
                return false;
            }
        };
        this._domain.getValidatorRegistry().addValidator((Validator)t);
        Assert.assertTrue((boolean)this._observer.addValidatorCalled);
        this._domain.getValidatorRegistry().removeValidator((Validator)t);
        Assert.assertTrue((boolean)this._observer.removeValidatorCalled);
    }

    @Test
    public void testReferenceEvents() {
        this._domain.addEventObserver((EventObserver)this._observer, ReferenceRegistrationEvent.class).addEventObserver((EventObserver)this._observer, ReferenceUnregistrationEvent.class);
        ServiceReference ref = this._domain.registerServiceReference(new QName("test"), (ServiceInterface)new InOutService());
        Assert.assertTrue((boolean)this._observer.referenceRegistrationCalled);
        ref.unregister();
        Assert.assertTrue((boolean)this._observer.referenceUnregistrationCalled);
    }

    @Test
    public void testServiceEvents() {
        this._domain.addEventObserver((EventObserver)this._observer, ServiceRegistrationEvent.class).addEventObserver((EventObserver)this._observer, ServiceUnregistrationEvent.class);
        Service service = this._domain.registerService(new QName("test"), (ServiceInterface)new InOutService(), (ExchangeHandler)new BaseHandler());
        Assert.assertTrue((boolean)this._observer.serviceRegistrationCalled);
        service.unregister();
        Assert.assertTrue((boolean)this._observer.serviceUnregistrationCalled);
    }
}

