/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.io;

import junit.framework.Assert;
import org.junit.Test;
import org.switchyard.internal.io.Data;
import org.switchyard.internal.io.GZIPSerializer;
import org.switchyard.internal.io.GraphSerializer;
import org.switchyard.internal.io.Serializer;
import org.switchyard.internal.io.SerializerType;
import org.switchyard.internal.io.ZIPSerializer;

public final class ComparisonSerializationTests {
    @Test
    public void testObjectStreamSerializer() throws Exception {
        this.doTestSerializer(SerializerType.OBJECT_STREAM);
    }

    @Test
    public void testBeanXMLSerializer() throws Exception {
        this.doTestSerializer(SerializerType.BEAN_XML);
    }

    @Test
    public void testGraphProtostuffSerializer() throws Exception {
        this.doTestSerializer(SerializerType.GRAPH_PROTOSTUFF);
    }

    @Test
    public void testNativeProtostuffSerializer() throws Exception {
        this.doTestSerializer(SerializerType.NATIVE_PROTOSTUFF);
    }

    @Test
    public void testProtobufProtostuffSerializer() throws Exception {
        this.doTestSerializer(SerializerType.PROTOBUF_PROTOSTUFF);
    }

    @Test
    public void testJSONProtostuffSerializer() throws Exception {
        this.doTestSerializer(SerializerType.JSON_PROTOSTUFF);
    }

    @Test
    public void testNumericJSONProtostuffSerializer() throws Exception {
        this.doTestSerializer(SerializerType.NUMERIC_JSON_PROTOSTUFF);
    }

    @Test
    public void testXMLProtostuffSerializer() throws Exception {
        this.doTestSerializer(SerializerType.XML_PROTOSTUFF);
    }

    private void doTestSerializer(SerializerType type) throws Exception {
        Serializer serializer = type.instance();
        this.doRunSerializer(serializer, 0, false);
        this.doRunSerializer((Serializer)new ZIPSerializer(serializer), 4, false);
        this.doRunSerializer((Serializer)new GZIPSerializer(serializer), 4, false);
        this.doRunSerializer((Serializer)new GraphSerializer(serializer), 4, false);
        this.doRunSerializer((Serializer)new ZIPSerializer((Serializer)new GraphSerializer(serializer)), 8, false);
        this.doRunSerializer((Serializer)new GZIPSerializer((Serializer)new GraphSerializer(serializer)), 8, true);
    }

    private void doRunSerializer(Serializer serializer, int spaces, boolean newline) throws Exception {
        Data.Car car = new Data.Car(new Data.Person("driver"));
        long start = System.currentTimeMillis();
        byte[] bytes = serializer.serialize((Object)car, Data.Car.class);
        car = (Data.Car)serializer.deserialize(bytes, Data.Car.class);
        long stop = System.currentTimeMillis();
        boolean debug = false;
        if (debug) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < spaces; ++i) {
                sb.append(' ');
            }
            sb.append(serializer.getClass().getSimpleName());
            sb.append(": ");
            sb.append(bytes.length);
            sb.append(" bytes serialized and deserialized in ");
            sb.append(stop - start);
            sb.append(" milliseconds");
            if (newline) {
                sb.append("\n");
            }
            System.out.println(sb);
        }
        Assert.assertEquals((String)"driver", (String)car.getDriver().getName());
    }
}

