/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.io;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import org.junit.Test;
import org.switchyard.internal.io.Data;
import org.switchyard.internal.io.Serializer;
import org.switchyard.internal.io.SerializerType;

public final class ComplexSerializationTests {
    private static final Serializer SERIALIZER = SerializerType.DEFAULT.instance();

    private <T> T serDeser(T object, Class<T> clazz) throws Exception {
        byte[] bytes = SERIALIZER.serialize(object, clazz);
        return (T)SERIALIZER.deserialize(bytes, clazz);
    }

    @Test
    public void testSpecificArray() throws Exception {
        Data.Car car = new Data.Car();
        car.setPassengers(new Data.Person[]{new Data.Person("passengerA"), new Data.Person("passengerB")});
        car = this.serDeser(car, Data.Car.class);
        Assert.assertEquals((int)2, (int)car.getPassengers().length);
        Assert.assertEquals((String)"passengerB", (String)car.getPassengers()[1].getName());
    }

    @Test
    public void testPolymorphicArray() throws Exception {
        Data.Car car = new Data.Car();
        car.setCheapParts(new Data.Part[]{new Data.Wheel(), new Data.CustomPart(true)});
        car = this.serDeser(car, Data.Car.class);
        Assert.assertEquals((int)2, (int)car.getCheapParts().length);
        Assert.assertEquals((boolean)true, (boolean)car.getCheapParts()[1].isReplaceable());
    }

    @Test
    public void testPolymorphicCollection() throws Exception {
        Data.Car car = new Data.Car();
        ArrayList<Data.Part> ep = new ArrayList<Data.Part>();
        for (int i = 0; i < 4; ++i) {
            ep.add(new Data.Wheel());
        }
        ep.add(new Data.CustomPart(false));
        car.setExpensiveParts(ep);
        car = this.serDeser(car, Data.Car.class);
        Assert.assertEquals((int)5, (int)car.getExpensiveParts().size());
        ArrayList<Data.Part> list = new ArrayList<Data.Part>(car.getExpensiveParts());
        Assert.assertEquals((boolean)true, (boolean)((Data.Part)list.get(3)).isReplaceable());
        Assert.assertEquals((boolean)false, (boolean)((Data.Part)list.get(4)).isReplaceable());
    }

    @Test
    public void testCircularReferences() throws Exception {
        Data.Person me = new Data.Person("me");
        Data.Person bff = new Data.Person("bff");
        me.setBestFriend(bff);
        bff.setBestFriend(me);
        Data.Person mom = new Data.Person("mom");
        Data.Person dad = new Data.Person("dad");
        mom.setBestFriend(dad);
        dad.setBestFriend(mom);
        me.getRelatives().add(mom);
        me.getRelatives().add(dad);
        mom.getRelatives().add(me);
        dad.getRelatives().add(me);
        me = this.serDeser(me, Data.Person.class);
        bff = me.getBestFriend();
        Iterator<Data.Person> parents = me.getRelatives().iterator();
        mom = parents.next();
        dad = parents.next();
        Assert.assertEquals((String)"me", (String)me.getName());
        Assert.assertEquals((String)"bff", (String)bff.getName());
        Assert.assertEquals((String)"mom", (String)mom.getName());
        Assert.assertEquals((String)"dad", (String)dad.getName());
        Assert.assertSame((Object)me, (Object)me.getBestFriend().getBestFriend());
        Assert.assertSame((Object)bff, (Object)bff.getBestFriend().getBestFriend());
        Assert.assertSame((Object)mom, (Object)mom.getBestFriend().getBestFriend());
        Assert.assertSame((Object)dad, (Object)dad.getBestFriend().getBestFriend());
        Assert.assertSame((Object)me, (Object)mom.getRelatives().iterator().next());
        Assert.assertSame((Object)me, (Object)dad.getRelatives().iterator().next());
    }
}

