/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public final class Data {
    private Data() {
    }

    public static final class CustomPart
    implements Part {
        private boolean _replaceable;

        public CustomPart() {
        }

        public CustomPart(boolean replaceable) {
            this.setReplaceable(replaceable);
        }

        @Override
        public boolean isReplaceable() {
            return this._replaceable;
        }

        public void setReplaceable(boolean replaceable) {
            this._replaceable = replaceable;
        }

        public String toString() {
            return "CustomPart(replaceable=" + this.isReplaceable() + ")";
        }
    }

    public static final class Wheel
    implements Part {
        @Override
        public boolean isReplaceable() {
            return true;
        }

        public String toString() {
            return "Wheel(replaceable=" + this.isReplaceable() + ")";
        }
    }

    public static interface Part {
        public boolean isReplaceable();
    }

    public static final class Car
    implements Serializable {
        private Person _driver;
        private Person[] _passengers;
        private Part[] _cheapParts;
        private Collection<Part> _expensiveParts;

        public Car() {
        }

        public Car(Person driver) {
            this.setDriver(driver);
        }

        public Person getDriver() {
            return this._driver;
        }

        public void setDriver(Person driver) {
            this._driver = driver;
        }

        public Person[] getPassengers() {
            return this._passengers;
        }

        public void setPassengers(Person[] passengers) {
            this._passengers = passengers;
        }

        public Part[] getCheapParts() {
            return this._cheapParts;
        }

        public void setCheapParts(Part[] cheapParts) {
            this._cheapParts = cheapParts;
        }

        public Collection<Part> getExpensiveParts() {
            return this._expensiveParts;
        }

        public void setExpensiveParts(Collection<Part> expensiveParts) {
            this._expensiveParts = expensiveParts;
        }

        public String toString() {
            return "Car(driver=" + this.getDriver() + ", passengers=" + Arrays.toString(this.getPassengers()) + ", cheapParts=" + Arrays.toString(this.getCheapParts()) + ", expensiveParts=" + this.getExpensiveParts() + ")";
        }
    }

    public static final class Person
    implements Serializable {
        private String _name;
        private Person _bestFriend;
        private Collection<Person> _relatives = new ArrayList<Person>();

        public Person() {
        }

        public Person(String name) {
            this.setName(name);
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public Person getBestFriend() {
            return this._bestFriend;
        }

        public void setBestFriend(Person bestFriend) {
            this._bestFriend = bestFriend;
        }

        public Collection<Person> getRelatives() {
            return this._relatives;
        }

        public void setRelatives(Collection<Person> relatives) {
            this._relatives = relatives;
        }

        public String toString() {
            return "Person(name=" + this.getName() + ", bestFriend=" + this.getBestFriend() + ", relatives=" + this.getRelatives() + ")";
        }
    }
}

