/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePhase;
import org.switchyard.ExchangeState;
import org.switchyard.Message;
import org.switchyard.MockDomain;
import org.switchyard.MockHandler;
import org.switchyard.ServiceReference;
import org.switchyard.internal.DefaultContext;
import org.switchyard.internal.DefaultMessage;
import org.switchyard.internal.ExchangeImpl;
import org.switchyard.internal.io.Data;
import org.switchyard.internal.io.Serializer;
import org.switchyard.internal.io.SerializerType;
import org.switchyard.metadata.ExchangeContract;

public final class ExchangeSerializationTests {
    private static final Serializer SERIALIZER = SerializerType.DEFAULT.instance();

    private static final <T> T serDeser(T object, Class<T> clazz) throws Exception {
        byte[] bytes = SERIALIZER.serialize(object, clazz);
        return (T)SERIALIZER.deserialize(bytes, clazz);
    }

    @Test
    public void testContextSerialization() throws Exception {
        DefaultContext ctx = this.buildContext(null);
        ctx = ExchangeSerializationTests.serDeser(ctx, DefaultContext.class);
        this.assertContext((Context)ctx);
    }

    @Test
    public void testMessageSerialization() throws Exception {
        DefaultMessage msg = this.buildMessage(null);
        msg = ExchangeSerializationTests.serDeser(msg, DefaultMessage.class);
        this.assertMessage((Message)msg);
    }

    @Test
    @Ignore
    public void testExchangeSerialization() throws Exception {
        ExchangeImpl exchange = this.buildExchange();
        exchange = ExchangeSerializationTests.serDeser(exchange, ExchangeImpl.class);
        this.assertExchange((Exchange)exchange);
    }

    private DefaultContext buildContext(DefaultContext ctx) {
        if (ctx == null) {
            ctx = new DefaultContext();
        }
        ctx.setProperty("foo", (Object)"bar");
        ctx.setProperty("car", (Object)new Data.Car(new Data.Person("driver")));
        return ctx;
    }

    private DefaultMessage buildMessage(DefaultMessage msg) {
        if (msg == null) {
            msg = new DefaultMessage();
        }
        msg.setContent((Object)"content");
        msg.addAttachment("data", (DataSource)new MockDataSource("mock", "text/plain", "abc123"));
        return msg;
    }

    private ExchangeImpl buildExchange() {
        MockDomain domain = new MockDomain();
        MockHandler handler = new MockHandler();
        ServiceReference service = domain.createInOutService(new QName("InPhase"), (ExchangeHandler)handler);
        ExchangeImpl exchange = (ExchangeImpl)service.createExchange((ExchangeHandler)handler);
        this.buildContext((DefaultContext)exchange.getContext());
        DefaultMessage msg = this.buildMessage((DefaultMessage)exchange.createMessage());
        exchange.send((Message)msg);
        handler.waitForOKMessage();
        return exchange;
    }

    private void assertContext(Context ctx) throws Exception {
        Assert.assertEquals((Object)"bar", (Object)ctx.getProperty("foo").getValue());
        Assert.assertEquals((String)"driver", (String)((Data.Car)ctx.getProperty("car").getValue()).getDriver().getName());
    }

    private void assertMessage(Message msg) throws Exception {
        Assert.assertEquals((Object)"content", (Object)msg.getContent());
        InputStream is = msg.getAttachment("data").getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[6];
        int read = 0;
        while ((read = is.read(buff)) != -1) {
            baos.write(buff, 0, read);
        }
        Assert.assertEquals((String)"abc123", (String)new String(baos.toByteArray()));
    }

    private void assertExchange(Exchange exchange) throws Exception {
        this.assertContext(exchange.getContext());
        this.assertMessage(exchange.getMessage());
        Assert.assertEquals((Object)ExchangeContract.IN_ONLY, (Object)exchange.getContract());
        Assert.assertEquals((Object)ExchangePhase.IN, (Object)exchange.getPhase());
        Assert.assertEquals((Object)ExchangeState.OK, (Object)exchange.getState());
    }

    private static final class MockDataSource
    implements DataSource {
        private String _name;
        private String _contentType;
        private String _content;

        private MockDataSource(String name, String contentType, String content) {
            this._name = name;
            this._contentType = contentType;
            this._content = content;
        }

        public String getName() {
            return this._name;
        }

        public String getContentType() {
            return this._contentType;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this._content.getBytes());
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }
    }
}

