/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.io.graph;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import org.switchyard.internal.io.graph.ArrayGraph;
import org.switchyard.internal.io.graph.ClassGraph;
import org.switchyard.internal.io.graph.CollectionGraph;
import org.switchyard.internal.io.graph.DataSourceGraph;
import org.switchyard.internal.io.graph.Graph;
import org.switchyard.internal.io.graph.GraphWrapper;
import org.switchyard.internal.io.graph.InputStreamGraph;
import org.switchyard.internal.io.graph.MapGraph;
import org.switchyard.internal.io.graph.PropertyGraph;
import org.switchyard.internal.io.graph.QNameGraph;
import org.switchyard.internal.io.graph.RawGraph;

public final class GraphBuilder {
    private static final Class<?>[] RAW_TYPES = new Class[]{Boolean.class, Calendar.class, Character.class, CharSequence.class, Date.class, Number.class};

    private GraphBuilder() {
    }

    public static <T> Graph<T> build(T object) throws IOException {
        return GraphBuilder.build(object, null);
    }

    static <T> Graph<T> build(T object, Map<Integer, Object> visited) throws IOException {
        boolean wrap;
        Graph<T> graph;
        if (object == null) {
            return null;
        }
        Integer id = System.identityHashCode(object);
        if (visited == null) {
            visited = new LinkedHashMap<Integer, Object>();
        }
        if ((graph = (RawGraph<T>)visited.get(id)) != null) {
            return graph;
        }
        Class<?> clazz = object.getClass();
        if (GraphBuilder.isRaw(clazz)) {
            graph = new RawGraph<T>();
            graph.compose(object, visited);
            wrap = false;
        } else if (GraphBuilder.isArray(clazz)) {
            if (GraphBuilder.isRaw(clazz.getComponentType())) {
                graph = new RawGraph();
                graph.compose(object, visited);
                wrap = false;
            } else {
                graph = new ArrayGraph();
                graph.compose(object, visited);
                wrap = true;
            }
        } else if (GraphBuilder.isClass(clazz)) {
            graph = new ClassGraph();
            graph.compose(object, visited);
            wrap = false;
        } else if (GraphBuilder.isCollection(clazz)) {
            graph = new CollectionGraph();
            graph.compose(object, visited);
            wrap = true;
        } else if (GraphBuilder.isMap(clazz)) {
            graph = new MapGraph();
            graph.compose(object, visited);
            wrap = true;
        } else if (GraphBuilder.isQName(clazz)) {
            graph = new QNameGraph();
            graph.compose(object, visited);
            wrap = false;
        } else if (GraphBuilder.isDataSource(clazz)) {
            graph = new DataSourceGraph();
            graph.compose(object, visited);
            wrap = false;
        } else if (GraphBuilder.isInputStream(clazz)) {
            graph = new InputStreamGraph();
            graph.compose(object, visited);
            wrap = false;
        } else {
            graph = new PropertyGraph();
            graph.compose(object, visited);
            wrap = true;
        }
        return wrap ? GraphWrapper.wrap(graph) : graph;
    }

    static boolean isArray(Class<?> clazz) {
        return clazz.isArray();
    }

    static boolean isClass(Class<?> clazz) {
        return Class.class.isAssignableFrom(clazz);
    }

    static boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    static boolean isDataSource(Class<?> clazz) {
        return DataSource.class.isAssignableFrom(clazz);
    }

    static boolean isInputStream(Class<?> clazz) {
        return InputStream.class.isAssignableFrom(clazz);
    }

    static boolean isMap(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    static boolean isQName(Class<?> clazz) {
        return QName.class.isAssignableFrom(clazz);
    }

    static boolean isRaw(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz.isEnum()) {
            return true;
        }
        for (Class<?> rt : RAW_TYPES) {
            if (!rt.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }
}

