/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.validate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.event.EventPublisher;
import org.switchyard.event.ValidatorAddedEvent;
import org.switchyard.event.ValidatorRemovedEvent;
import org.switchyard.validate.Validator;
import org.switchyard.validate.ValidatorRegistry;

public class BaseValidatorRegistry
implements ValidatorRegistry {
    private static Logger _log = Logger.getLogger(BaseValidatorRegistry.class);
    private final ConcurrentHashMap<QName, Validator<?>> _validators = new ConcurrentHashMap();
    private final ConcurrentHashMap<QName, Validator<?>> _fallbackValidators = new ConcurrentHashMap();
    private EventPublisher _eventPublisher;

    public BaseValidatorRegistry() {
    }

    public BaseValidatorRegistry(Set<Validator<?>> validators) {
        for (Validator<?> t : validators) {
            this.addValidator((Validator)t);
        }
    }

    public BaseValidatorRegistry addValidator(Validator<?> validator) {
        this._fallbackValidators.clear();
        this._validators.put(validator.getName(), validator);
        this.publishEvent((EventObject)new ValidatorAddedEvent(validator));
        return this;
    }

    public ValidatorRegistry addValidator(Validator<?> validator, QName name) {
        this._fallbackValidators.clear();
        this._validators.put(name, validator);
        this.publishEvent((EventObject)new ValidatorAddedEvent(validator));
        return null;
    }

    public Validator<?> getValidator(QName name) {
        Validator<?> validator = this._validators.get(name);
        if (validator == null) {
            validator = this._fallbackValidators.get(name);
            if (validator == null && QNameUtil.isJavaMessageType((QName)name)) {
                validator = this.getJavaFallbackValidator(name);
                if (validator != null && _log.isDebugEnabled()) {
                    _log.debug((Object)("Selecting fallback validator: name '" + validator.getName() + "'. Type: " + validator.getClass().getName()));
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)("No compatible validator registered: name '" + name + "'"));
                }
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("Selecting validator: name '" + validator.getName() + "'. Type: " + validator.getClass().getName()));
        }
        return validator;
    }

    public boolean hasValidator(QName name) {
        return this._validators.containsKey(name);
    }

    public boolean removeValidator(Validator<?> validator) {
        boolean removed;
        this._fallbackValidators.clear();
        boolean bl = removed = this._validators.remove(validator.getName()) != null;
        if (removed) {
            this.publishEvent((EventObject)new ValidatorRemovedEvent(validator));
        }
        return removed;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this._eventPublisher = eventPublisher;
    }

    private void publishEvent(EventObject event) {
        if (this._eventPublisher != null) {
            this._eventPublisher.publish(event);
        }
    }

    private Validator<?> getJavaFallbackValidator(QName name) {
        Class javaType = QNameUtil.toJavaMessageType((QName)name);
        if (javaType == null) {
            return null;
        }
        Set<Map.Entry<QName, Validator<?>>> entrySet = this._validators.entrySet();
        ArrayList<JavaSourceFallbackValidator> fallbackValidates = new ArrayList<JavaSourceFallbackValidator>();
        for (Map.Entry<QName, Validator<?>> entry : entrySet) {
            Class candidateType;
            QName nameKey = entry.getKey();
            if (!QNameUtil.isJavaMessageType((QName)nameKey) || (candidateType = QNameUtil.toJavaMessageType((QName)nameKey)) == null || !candidateType.isAssignableFrom(javaType)) continue;
            fallbackValidates.add(new JavaSourceFallbackValidator(candidateType, entry.getValue()));
        }
        if (fallbackValidates.size() == 0) {
            return null;
        }
        if (fallbackValidates.size() == 1) {
            Validator fallbackValidator = ((JavaSourceFallbackValidator)fallbackValidates.get(0))._validator;
            this.addFallbackValidator(fallbackValidator, name);
            return fallbackValidator;
        }
        JavaSourceFallbackValidatorComparator comparator = new JavaSourceFallbackValidatorComparator();
        Collections.sort(fallbackValidates, comparator);
        if (_log.isDebugEnabled()) {
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("Multiple possible fallback validators available:");
            for (JavaSourceFallbackValidator t : fallbackValidates) {
                messageBuilder.append("\n\t- name '" + t._validator.getName() + "'");
            }
            _log.debug((Object)messageBuilder.toString());
        }
        Validator fallbackValidator = ((JavaSourceFallbackValidator)fallbackValidates.get(0))._validator;
        this.addFallbackValidator(fallbackValidator, name);
        return fallbackValidator;
    }

    private void addFallbackValidator(Validator<?> fallbackValidator, QName name) {
        this._fallbackValidators.put(name, fallbackValidator);
    }

    public static class JavaSourceFallbackValidatorComparator<T extends JavaSourceFallbackValidator>
    implements Comparator<T>,
    Serializable {
        @Override
        public int compare(T t1, T t2) {
            if (((JavaSourceFallbackValidator)t1)._javaType == ((JavaSourceFallbackValidator)t2)._javaType) {
                return 0;
            }
            if (((JavaSourceFallbackValidator)t1)._javaType.isAssignableFrom(((JavaSourceFallbackValidator)t2)._javaType)) {
                return 1;
            }
            if (((JavaSourceFallbackValidator)t2)._javaType.isAssignableFrom(((JavaSourceFallbackValidator)t1)._javaType)) {
                return -1;
            }
            return 0;
        }
    }

    public static class JavaSourceFallbackValidator {
        private Class<?> _javaType;
        private Validator<?> _validator;

        public JavaSourceFallbackValidator(Class<?> javaType, Validator<?> validator) {
            this._javaType = javaType;
            this._validator = validator;
        }

        public Class<?> getJavaType() {
            return this._javaType;
        }
    }
}

