/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.Service;
import org.switchyard.ServiceDomain;
import org.switchyard.event.ServiceUnregistrationEvent;
import org.switchyard.internal.DomainImpl;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.policy.Policy;

public class ServiceImpl
implements Service {
    private QName _name;
    private ServiceInterface _interface;
    private DomainImpl _domain;
    private List<Policy> _requires;

    public ServiceImpl(QName name, ServiceInterface serviceInterface, List<Policy> requires, DomainImpl domain) {
        this._name = name;
        this._interface = serviceInterface;
        this._domain = domain;
        this._requires = requires != null ? requires : Collections.emptyList();
    }

    public ServiceInterface getInterface() {
        return this._interface;
    }

    public QName getName() {
        return this._name;
    }

    public ServiceDomain getDomain() {
        return this._domain;
    }

    public void unregister() {
        this._domain.getServiceRegistry().unregisterService(this);
        this._domain.getEventPublisher().publish((EventObject)new ServiceUnregistrationEvent((Service)this));
    }

    public List<Policy> getRequiredPolicy() {
        return Collections.unmodifiableList(this._requires);
    }
}

