/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.internal.DomainImpl;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.policy.ExchangePolicy;
import org.switchyard.policy.Policy;

public class ServiceReferenceImpl
implements ServiceReference {
    private QName _name;
    private ServiceInterface _interface;
    private DomainImpl _domain;
    private List<Policy> _provides;
    private ExchangeHandler _handler;

    public ServiceReferenceImpl(QName name, ServiceInterface serviceInterface, List<Policy> provides, ExchangeHandler handler, DomainImpl domain) {
        this._name = name;
        this._interface = serviceInterface;
        this._handler = handler;
        this._domain = domain;
        this._provides = provides != null ? provides : Collections.emptyList();
    }

    public Exchange createExchange() {
        return this.createExchange(this._handler);
    }

    public Exchange createExchange(ExchangeHandler handler) {
        Set operations = this._interface.getOperations();
        if (operations.size() == 0) {
            throw new SwitchYardException("No operations in interface for service: " + this._name);
        }
        if (operations.size() > 1) {
            throw new SwitchYardException("Operation name required - multiple operations on service interface: " + this._name);
        }
        return this.createExchange(((ServiceOperation)operations.iterator().next()).getName(), handler);
    }

    public Exchange createExchange(String operation) {
        return this.createExchange(operation, this._handler);
    }

    public Exchange createExchange(String operation, ExchangeHandler handler) {
        Exchange ex = this._domain.createExchange(this, operation, handler);
        for (Policy policy : this._provides) {
            ExchangePolicy.provide((Exchange)ex, (Policy)policy);
        }
        return ex;
    }

    public ServiceInterface getInterface() {
        return this._interface;
    }

    public QName getName() {
        return this._name;
    }

    public List<Policy> getProvidedPolicy() {
        return Collections.unmodifiableList(this._provides);
    }

    public void unregister() {
        this._domain.unregisterServiceReference(this);
    }

    public ServiceDomain getDomain() {
        return this._domain;
    }
}

