/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import javax.transaction.TransactionManager;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.MockExchange;
import org.switchyard.handlers.MockTransactionManager;
import org.switchyard.handlers.TransactionHandler;
import org.switchyard.internal.DefaultContext;
import org.switchyard.policy.Policy;
import org.switchyard.policy.PolicyUtil;
import org.switchyard.policy.TransactionPolicy;

public class TransactionHandlerTest {
    private MockTransactionManager tm;
    private MockExchange exchange;
    private TransactionHandler handler;

    @Before
    public void setUp() {
        this.tm = new MockTransactionManager();
        this.exchange = new MockExchange();
        this.exchange.setContext((Context)new DefaultContext());
        this.handler = new TransactionHandler();
        this.handler.setTransactionManager((TransactionManager)this.tm);
    }

    @Test
    public void incompatibleRequirements() {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION);
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            System.out.println(handlerEx.toString());
            return;
        }
        Assert.fail((String)"Expected a handler exception due to incompatible policy");
    }

    @Test
    public void propagateProvidedButNotRequired() {
        PolicyUtil.provide((Exchange)this.exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            Assert.fail((String)("Exception not expected when transaction is provided but not required: " + (Object)((Object)handlerEx)));
        }
    }

    @Test
    public void propagateRequiredButNotProvided() {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
        this.exchange.setPhase(ExchangePhase.IN);
        try {
            this.handler.handleMessage((Exchange)this.exchange);
        }
        catch (HandlerException handlerEx) {
            System.out.println(handlerEx.toString());
            return;
        }
        Assert.fail((String)"Handler should fail when propagation required, but not provided");
    }

    @Test
    public void suspendTransaction() throws Exception {
        PolicyUtil.require((Exchange)this.exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION);
        this.exchange.setPhase(ExchangePhase.IN);
        this.handler.handleMessage((Exchange)this.exchange);
        Assert.assertFalse((boolean)this.tm.getTransaction().active);
        this.exchange.setPhase(ExchangePhase.OUT);
        this.handler.handleMessage((Exchange)this.exchange);
        Assert.assertTrue((boolean)this.tm.getTransaction().active);
    }
}

