/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.policy.Policy;
import org.switchyard.policy.PolicyUtil;
import org.switchyard.policy.TransactionPolicy;

public class TransactionHandler
implements ExchangeHandler {
    private static final String JNDI_TRANSACTION_MANAGER = "java:jboss/TransactionManager";
    private static final String TRANSACTION_PROPERTY = "org.switchyard.exchange.transaction";
    private static Logger _log = Logger.getLogger(TransactionHandler.class);
    private TransactionManager _transactionManager;

    public TransactionHandler() {
        try {
            this._transactionManager = (TransactionManager)new InitialContext().lookup(JNDI_TRANSACTION_MANAGER);
        }
        catch (NamingException nmEx) {
            _log.debug((Object)"Unable to find TransactionManager in JNDI at java:jboss/TransactionManager - Transaction Policy handling will not be available.");
        }
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        if (this._transactionManager == null) {
            return;
        }
        if (ExchangePhase.OUT.equals((Object)exchange.getPhase())) {
            this.handleOut(exchange);
        } else {
            this.handleIn(exchange);
        }
    }

    public void handleFault(Exchange exchange) {
        this.handleOut(exchange);
    }

    void setTransactionManager(TransactionManager transactionManager) {
        this._transactionManager = transactionManager;
    }

    TransactionManager getTransactionManager() {
        return this._transactionManager;
    }

    private void handleOut(Exchange exchange) {
        if (!this.suspendsRequired(exchange)) {
            return;
        }
        Transaction transaction = (Transaction)exchange.getContext().getPropertyValue(TRANSACTION_PROPERTY);
        if (transaction != null) {
            this.resumeTransaction(transaction);
        }
    }

    private void handleIn(Exchange exchange) throws HandlerException {
        if (this.suspendsRequired(exchange) && this.propagatesRequired(exchange)) {
            throw new HandlerException("Invalid transaction policy : " + TransactionPolicy.SUSPENDS_TRANSACTION + " and " + TransactionPolicy.PROPAGATES_TRANSACTION + " cannot be requested simultaneously.");
        }
        if (this.propagatesRequired(exchange) && !this.propagatesProvided(exchange)) {
            throw new HandlerException("Transaction policy requires an active transaction, but no transaction is present.");
        }
        if (this.suspendsRequired(exchange)) {
            Transaction transaction = (Transaction)exchange.getContext().getPropertyValue(TRANSACTION_PROPERTY);
            if (transaction == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Suspending active transaction for exchange.");
                }
                try {
                    transaction = this._transactionManager.suspend();
                }
                catch (SystemException sysEx) {
                    throw new HandlerException("Failed to suspend transaction on exchange.", (Throwable)sysEx);
                }
                if (transaction != null) {
                    exchange.getContext().setProperty(TRANSACTION_PROPERTY, (Object)transaction);
                }
                PolicyUtil.provide((Exchange)exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION);
            } else if (this.isInOnly(exchange)) {
                this.resumeTransaction(transaction);
            }
        }
    }

    private boolean propagatesProvided(Exchange exchange) {
        return PolicyUtil.isProvided((Exchange)exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
    }

    private boolean suspendsRequired(Exchange exchange) {
        return PolicyUtil.isRequired((Exchange)exchange, (Policy)TransactionPolicy.SUSPENDS_TRANSACTION);
    }

    private boolean propagatesRequired(Exchange exchange) {
        return PolicyUtil.isRequired((Exchange)exchange, (Policy)TransactionPolicy.PROPAGATES_TRANSACTION);
    }

    private boolean isInOnly(Exchange exchange) {
        return ExchangePattern.IN_ONLY.equals((Object)exchange.getContract().getServiceOperation().getExchangePattern());
    }

    private void resumeTransaction(Transaction transaction) {
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Resuming suspended transaction");
            }
            this._transactionManager.resume(transaction);
        }
        catch (Exception ex) {
            _log.error((Object)"Failed to resume transaction after service invocation.", (Throwable)ex);
        }
    }
}

