/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.Set;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.internal.ContextProperty;
import org.switchyard.internal.ScopedPropertyMap;
import org.switchyard.io.Serialization;

@Serialization.Strategy(access=Serialization.AccessType.FIELD, coverage=Serialization.CoverageType.INCLUSIVE)
public class DefaultContext
implements Context {
    private ScopedPropertyMap _properties;

    public DefaultContext() {
        this._properties = new ScopedPropertyMap();
    }

    DefaultContext(ScopedPropertyMap properties) {
        this._properties = properties;
    }

    public Property getProperty(String name, Scope scope) {
        return this._properties.get(scope, name);
    }

    public Object getPropertyValue(String name) {
        Property prop = this._properties.get(Scope.EXCHANGE, name);
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    public void removeProperties() {
        this._properties.clear();
    }

    public void removeProperties(Scope scope) {
        this._properties.clear(scope);
    }

    public Context setProperties(Set<Property> properties) {
        for (Property p : properties) {
            this._properties.put(p);
        }
        return this;
    }

    public Property setProperty(String name, Object val, Scope scope) {
        ContextProperty p = new ContextProperty(name, scope, val);
        if (val != null) {
            this._properties.put(p);
            return p;
        }
        this.removeProperty(p);
        return null;
    }

    public Set<Property> getProperties() {
        return this._properties.get();
    }

    public Set<Property> getProperties(Scope scope) {
        return this._properties.get(scope);
    }

    public void removeProperty(Property property) {
        this._properties.remove(property);
    }

    public Property getProperty(String name) {
        return this._properties.get(Scope.EXCHANGE, name);
    }

    public Property setProperty(String name, Object val) {
        ContextProperty p = new ContextProperty(name, Scope.EXCHANGE, val);
        this._properties.put(p);
        return p;
    }

    public DefaultContext copy() {
        return new DefaultContext(this._properties.copy());
    }
}

