/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerChain;
import org.switchyard.Service;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.event.EventObserver;
import org.switchyard.event.EventPublisher;
import org.switchyard.event.ReferenceRegistrationEvent;
import org.switchyard.event.ReferenceUnregistrationEvent;
import org.switchyard.event.ServiceRegistrationEvent;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.handlers.PolicyHandler;
import org.switchyard.handlers.TransactionHandler;
import org.switchyard.handlers.TransformHandler;
import org.switchyard.handlers.ValidateHandler;
import org.switchyard.internal.DefaultHandlerChain;
import org.switchyard.internal.EventManager;
import org.switchyard.internal.ExchangeImpl;
import org.switchyard.internal.ServiceImpl;
import org.switchyard.internal.ServiceReferenceImpl;
import org.switchyard.metadata.BaseExchangeContract;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.InOutService;
import org.switchyard.metadata.ServiceInterface;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.policy.Policy;
import org.switchyard.policy.PolicyUtil;
import org.switchyard.spi.Dispatcher;
import org.switchyard.spi.ExchangeBus;
import org.switchyard.spi.ServiceRegistry;
import org.switchyard.transform.TransformerRegistry;
import org.switchyard.validate.ValidatorRegistry;

public class DomainImpl
implements ServiceDomain {
    private static Logger _logger = Logger.getLogger(DomainImpl.class);
    private final QName _name;
    private final DefaultHandlerChain _defaultHandlers;
    private final EventManager _eventManager;
    private final ServiceRegistry _registry;
    private final ExchangeBus _exchangeBus;
    private final TransformerRegistry _transformerRegistry;
    private final ValidatorRegistry _validatorRegistry;
    private final Map<QName, ServiceReference> _references;

    public DomainImpl(QName name, ServiceRegistry registry, ExchangeBus exchangeBus, TransformerRegistry transformerRegistry, ValidatorRegistry validatorRegistry, EventManager eventManager) {
        this._name = name;
        this._registry = registry;
        this._exchangeBus = exchangeBus;
        this._transformerRegistry = transformerRegistry;
        this._validatorRegistry = validatorRegistry;
        this._eventManager = eventManager;
        this._references = new ConcurrentHashMap<QName, ServiceReference>();
        this.setEventPublisher(this._transformerRegistry);
        this.setEventPublisher(this._validatorRegistry);
        TransactionHandler transactionHandler = new TransactionHandler();
        ValidateHandler validateHandler = new ValidateHandler(this._validatorRegistry);
        this._defaultHandlers = new DefaultHandlerChain();
        this._defaultHandlers.addLast("transaction-pre-invoke", transactionHandler);
        this._defaultHandlers.addLast("generic-policy", new PolicyHandler());
        this._defaultHandlers.addLast("validation-before-transform", (ExchangeHandler)validateHandler);
        this._defaultHandlers.addLast("transformation", (ExchangeHandler)new TransformHandler(this._transformerRegistry));
        this._defaultHandlers.addLast("validation-after-transform", (ExchangeHandler)validateHandler);
        this._defaultHandlers.addLast("provider", (ExchangeHandler)new BaseHandler());
        this._defaultHandlers.addLast("transaction-post-invoke", transactionHandler);
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Created SwitchYard ServiceDomain instance '" + name + "'."));
        }
    }

    public Service registerService(QName serviceName, ServiceInterface metadata, ExchangeHandler handler) {
        List<Policy> requires = Collections.emptyList();
        return this.registerService(serviceName, metadata, handler, requires);
    }

    public Service registerService(QName serviceName, ServiceInterface metadata, ExchangeHandler handler, List<Policy> requires) {
        if (metadata == null) {
            metadata = new InOutService();
        }
        ServiceImpl service = new ServiceImpl(serviceName, metadata, requires, this);
        DefaultHandlerChain handlers = this._defaultHandlers.copy();
        handlers.replace("provider", handler);
        Dispatcher ep = this._exchangeBus.createDispatcher(service, handlers, this._transformerRegistry);
        this._registry.registerService(service, ep, this);
        this._eventManager.publish((EventObject)new ServiceRegistrationEvent((Service)service));
        return service;
    }

    public ServiceReference registerServiceReference(QName serviceName, ServiceInterface metadata) {
        return this.registerServiceReference(serviceName, metadata, null, null);
    }

    public ServiceReference registerServiceReference(QName serviceName, ServiceInterface metadata, ExchangeHandler handler) {
        return this.registerServiceReference(serviceName, metadata, handler, null);
    }

    public ServiceReference registerServiceReference(QName serviceName, ServiceInterface metadata, ExchangeHandler handler, List<Policy> provides) {
        ServiceReferenceImpl reference = new ServiceReferenceImpl(serviceName, metadata, provides, handler, this);
        this._references.put(serviceName, reference);
        this._eventManager.publish((EventObject)new ReferenceRegistrationEvent((ServiceReference)reference));
        return reference;
    }

    public ServiceReference getServiceReference(QName serviceName) {
        return this._references.get(serviceName);
    }

    public void unregisterServiceReference(ServiceReference reference) {
        this._references.remove(reference.getName());
        this._eventManager.publish((EventObject)new ReferenceUnregistrationEvent(reference));
    }

    public void wireReference(ServiceReference reference, Service service) {
    }

    public Exchange createExchange(ServiceReference reference, String operation) {
        return this.createExchange(reference, operation, null);
    }

    public Exchange createExchange(ServiceReference reference, String operation, ExchangeHandler handler) {
        ServiceOperation serviceOp;
        ServiceOperation referenceOp;
        List<Service> services = this._registry.getServices(reference.getName());
        if (services == null || services.isEmpty()) {
            throw new SwitchYardException("No registered service found for " + reference.getName());
        }
        Service service = services.get(0);
        Dispatcher dispatcher = this._exchangeBus.getDispatcher(service);
        DefaultHandlerChain replyChain = null;
        if (handler != null) {
            replyChain = this._defaultHandlers.copy();
            replyChain.addLast("replyHandler", handler);
        }
        if ((referenceOp = reference.getInterface().getOperation(operation)) == null) {
            if (reference.getInterface().getOperations().size() == 1) {
                referenceOp = (ServiceOperation)reference.getInterface().getOperations().iterator().next();
            } else {
                throw new SwitchYardException("Operation " + operation + " is not included in interface for reference: " + reference.getName());
            }
        }
        if ((serviceOp = service.getInterface().getOperation(operation)) == null) {
            if (service.getInterface().getOperations().size() == 1) {
                serviceOp = (ServiceOperation)service.getInterface().getOperations().iterator().next();
            } else {
                throw new SwitchYardException("Operation " + operation + " is not included in interface for service: " + service.getName());
            }
        }
        BaseExchangeContract contract = new BaseExchangeContract(serviceOp, referenceOp);
        ExchangeImpl exchange = new ExchangeImpl(service.getName(), (ExchangeContract)contract, dispatcher, this, replyChain);
        for (Policy policy : service.getRequiredPolicies()) {
            PolicyUtil.require((Exchange)exchange, (Policy)policy);
        }
        return exchange;
    }

    public QName getName() {
        return this._name;
    }

    public TransformerRegistry getTransformerRegistry() {
        return this._transformerRegistry;
    }

    public ValidatorRegistry getValidatorRegistry() {
        return this._validatorRegistry;
    }

    public ServiceRegistry getServiceRegistry() {
        return this._registry;
    }

    public ExchangeBus getBus() {
        return this._exchangeBus;
    }

    public HandlerChain getHandlerChain() {
        return this._defaultHandlers;
    }

    public ServiceDomain addEventObserver(EventObserver observer, Class<? extends EventObject> eventType) {
        this._eventManager.addObserver(observer, eventType);
        return this;
    }

    public EventPublisher getEventPublisher() {
        return this._eventManager;
    }

    private void setEventPublisher(Object target) {
        if (target == null) {
            return;
        }
        try {
            Method setter = target.getClass().getMethod("setEventPublisher", EventPublisher.class);
            setter.invoke(target, this._eventManager);
        }
        catch (Exception ex) {
            _logger.debug((Object)("Attempt to set EventPublisher failed on " + target.getClass().getCanonicalName()), (Throwable)ex);
        }
    }
}

