/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.switchyard.event.EventObserver;
import org.switchyard.event.EventPublisher;

public class EventManager
implements EventPublisher {
    private static Logger _logger = Logger.getLogger(EventManager.class);
    private Map<Class<? extends EventObject>, List<EventObserver>> _observers = new ConcurrentHashMap<Class<? extends EventObject>, List<EventObserver>>();

    public void publish(EventObject event) {
        for (EventObserver observer : this.getObserversForEvent(event.getClass())) {
            try {
                observer.notify(event);
            }
            catch (Throwable t) {
                _logger.debug((Object)("Observer threw exception on event " + event.getClass()), t);
            }
        }
    }

    public List<EventObserver> getObserversForEvent(Class<? extends EventObject> event) {
        if (this._observers.containsKey(event)) {
            return this._observers.get(event);
        }
        return Collections.emptyList();
    }

    public synchronized EventManager addObserver(EventObserver observer, Class<? extends EventObject> event) {
        List<EventObserver> observerList = this._observers.get(event);
        if (observerList == null) {
            observerList = new LinkedList<EventObserver>();
            this._observers.put(event, observerList);
        }
        observerList.add(observer);
        _logger.debug((Object)("Observer added for event " + event.getCanonicalName()));
        return this;
    }

    public synchronized void removeObserver(EventObserver observer) {
        for (List<EventObserver> observers : this._observers.values()) {
            observers.remove(observer);
        }
    }

    public synchronized void removeObserverForEvent(EventObserver observer, Class<? extends EventObject> event) {
        List<EventObserver> observers = this._observers.get(event);
        if (observers != null) {
            observers.remove(observer);
        }
    }
}

