/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.io.IOException;
import java.util.EventObject;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.ExchangeState;
import org.switchyard.HandlerChain;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.internal.DefaultContext;
import org.switchyard.internal.DefaultMessage;
import org.switchyard.io.Serialization;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.runtime.event.ExchangeCompletionEvent;
import org.switchyard.spi.Dispatcher;
import org.switchyard.transform.TransformSequence;
import org.switchyard.transform.TransformerRegistry;

@Serialization.Strategy(access=Serialization.AccessType.FIELD, coverage=Serialization.CoverageType.EXCLUSIVE, factory=ExchangeImplFactory.class)
public class ExchangeImpl
implements Exchange {
    private static Logger _log = Logger.getLogger(ExchangeImpl.class);
    @Serialization.Include
    private ExchangeContract _contract;
    @Serialization.Include
    private ExchangePhase _phase;
    @Serialization.Include
    private QName _serviceName;
    @Serialization.Include
    private Message _message;
    @Serialization.Include
    private ExchangeState _state = ExchangeState.OK;
    private Dispatcher _dispatch;
    private TransformerRegistry _transformerRegistry;
    private HandlerChain _replyChain;
    private ServiceDomain _domain;
    private Long _startTime;
    @Serialization.Include
    private Context _context;

    private ExchangeImpl() {
    }

    public ExchangeImpl(QName serviceName, ExchangeContract contract, Dispatcher dispatch, ServiceDomain domain) {
        this(serviceName, contract, dispatch, domain, null);
        if (_log.isDebugEnabled()) {
            ServiceOperation serviceOperation = contract.getServiceOperation();
            _log.debug((Object)("Created " + serviceOperation.getExchangePattern() + " Exchange instance (" + this.instanceHash() + ") for Service '" + serviceName + "', operation '" + serviceOperation.getName() + "'.  No response handler."));
        }
    }

    public ExchangeImpl(QName serviceName, ExchangeContract contract, Dispatcher dispatch, ServiceDomain domain, HandlerChain replyChain) {
        if (contract == null) {
            throw new IllegalArgumentException("null 'contract' arg.");
        }
        if (contract.getInvokerInvocationMetaData() == null) {
            throw new IllegalArgumentException("Invalid 'contract' arg.  No invoker invocation metadata defined on the contract instance.");
        }
        if (contract.getServiceOperation() == null) {
            throw new IllegalArgumentException("Invalid 'contract' arg.  No ServiceOperation defined on the contract instance.");
        }
        ExchangePattern exchangePattern = contract.getServiceOperation().getExchangePattern();
        if (replyChain == null && exchangePattern == ExchangePattern.IN_OUT) {
            throw new SwitchYardException("Invalid Exchange construct.  Must supply an reply handler for an IN_OUT Exchange.");
        }
        this._domain = domain;
        this._serviceName = serviceName;
        this._contract = contract;
        this._dispatch = dispatch;
        this._transformerRegistry = domain.getTransformerRegistry();
        this._replyChain = replyChain;
        this._context = new DefaultContext();
        if (_log.isDebugEnabled()) {
            ServiceOperation serviceOperation = contract.getServiceOperation();
            _log.debug((Object)("Created " + serviceOperation.getExchangePattern() + " Exchange instance (" + this.instanceHash() + ") for Service '" + serviceName + "', operation '" + serviceOperation.getName() + "'.  Response HandlerChain: " + this._replyChain));
        }
    }

    public Context getContext() {
        return this._context;
    }

    public ExchangeContract getContract() {
        return this._contract;
    }

    public QName getServiceName() {
        return this._serviceName;
    }

    public Message getMessage() {
        return this._message;
    }

    public synchronized void send(Message message) {
        this.assertMessageOK(message);
        if (this._phase == null) {
            this._phase = ExchangePhase.IN;
            this.initInContentType();
            this.initInTransformSequence();
        } else if (this._phase.equals((Object)ExchangePhase.IN)) {
            this._phase = ExchangePhase.OUT;
            this.initOutContentType();
            this.initOutTransformSequence();
            this._context.setProperty("org.switchyard.relatesTo", this._context.getProperty("org.switchyard.messageId", Scope.IN).getValue(), Scope.OUT);
        } else {
            throw new IllegalStateException("Send message not allowed for exchange in phase " + this._phase);
        }
        this.sendInternal(message);
    }

    public synchronized void sendFault(Message message) {
        this.assertMessageOK(message);
        if (this._phase == null) {
            throw new IllegalStateException("Send fault no allowed on new exchanges");
        }
        this._phase = ExchangePhase.OUT;
        this._state = ExchangeState.FAULT;
        this.sendInternal(message);
    }

    public ExchangeState getState() {
        return this._state;
    }

    public Dispatcher getDispatcher() {
        return this._dispatch;
    }

    public HandlerChain getReplyChain() {
        return this._replyChain;
    }

    public void setOutputDispatcher(Dispatcher dispatch) {
        this._dispatch = dispatch;
    }

    private void sendInternal(Message message) {
        if (this._startTime == null) {
            this._startTime = System.nanoTime();
        }
        ExchangePhase sendPhase = this._phase;
        this._message = message;
        this._context.setProperty("org.switchyard.messageId", (Object)UUID.randomUUID().toString(), Scope.activeScope((Exchange)this));
        if (_log.isDebugEnabled()) {
            ServiceOperation serviceOperation = this._contract.getServiceOperation();
            _log.debug((Object)("Sending " + this._phase + " Message (" + System.identityHashCode(message) + ") on " + serviceOperation.getExchangePattern() + " Exchange (" + this.instanceHash() + ") for Service '" + this._serviceName + "', operation '" + serviceOperation.getName() + "'.  Exchange state: " + this._state));
        }
        if (ExchangeState.FAULT.equals((Object)this._state) && this._replyChain == null) {
            String faultContent;
            try {
                faultContent = (String)this._message.getContent(String.class);
            }
            catch (Exception ex) {
                faultContent = this._message.getContent().toString();
            }
            _log.warn((Object)("Fault generated during exchange without a handler: " + faultContent));
        } else {
            this._dispatch.dispatch(this);
        }
        if (this.isDone(sendPhase)) {
            long duration = System.nanoTime() - this._startTime;
            this.getContext().setProperty("org.switchyard.exchangeDurationMS", (Object)TimeUnit.MILLISECONDS.convert(duration, TimeUnit.NANOSECONDS));
            this._domain.getEventPublisher().publish((EventObject)new ExchangeCompletionEvent(this));
        }
    }

    private int instanceHash() {
        return System.identityHashCode(this);
    }

    private void assertMessageOK(Message message) {
        if (message == null) {
            throw new IllegalArgumentException("Invalid null 'message' argument in method call.");
        }
        if (this._state == ExchangeState.FAULT) {
            throw new IllegalStateException("Exchange instance is in a FAULT state.");
        }
    }

    public Message createMessage() {
        return new DefaultMessage().setTransformerRegistry(this._transformerRegistry);
    }

    public ExchangePhase getPhase() {
        return this._phase;
    }

    private void initInTransformSequence() {
        QName exchangeInputType = this._contract.getInvokerInvocationMetaData().getInputType();
        QName serviceOperationInputType = this._contract.getServiceOperation().getInputType();
        if (exchangeInputType != null && serviceOperationInputType != null) {
            TransformSequence.from((QName)exchangeInputType).to(serviceOperationInputType).associateWith((Exchange)this, Scope.IN);
        }
    }

    private void initOutTransformSequence() {
        QName serviceOperationOutputType = this._contract.getServiceOperation().getOutputType();
        QName exchangeOutputType = this._contract.getInvokerInvocationMetaData().getOutputType();
        if (serviceOperationOutputType != null && exchangeOutputType != null) {
            TransformSequence.from((QName)serviceOperationOutputType).to(exchangeOutputType).associateWith((Exchange)this, Scope.OUT);
        }
    }

    private void initInContentType() {
        QName exchangeInputType = this._contract.getInvokerInvocationMetaData().getInputType();
        if (exchangeInputType != null) {
            this._context.setProperty("org.switchyard.contentType", (Object)exchangeInputType, Scope.IN);
        }
    }

    private void initOutContentType() {
        QName serviceOperationOutputType = this._contract.getServiceOperation().getOutputType();
        if (serviceOperationOutputType != null) {
            this._context.setProperty("org.switchyard.contentType", (Object)serviceOperationOutputType, Scope.OUT);
        }
    }

    private boolean isDone(ExchangePhase phase) {
        ExchangePattern mep = this._contract.getServiceOperation().getExchangePattern();
        return ExchangePhase.IN.equals((Object)phase) && ExchangePattern.IN_ONLY.equals((Object)mep) || ExchangePhase.OUT.equals((Object)phase) && ExchangePattern.IN_OUT.equals((Object)mep);
    }

    public static final class ExchangeImplFactory
    implements Serialization.Factory<ExchangeImpl> {
        public ExchangeImpl create(Class<ExchangeImpl> type) throws IOException {
            return new ExchangeImpl();
        }
    }
}

