/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Logger;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;

public class MessageTrace
implements ExchangeHandler {
    private static final String INDENT = System.getProperty("line.separator");
    private static Logger _log = Logger.getLogger(MessageTrace.class);

    public void handleFault(Exchange exchange) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)this.createTrace(exchange));
        }
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)this.createTrace(exchange));
        }
    }

    String createTrace(Exchange exchange) {
        String content;
        StringBuilder summary;
        block7: {
            summary = new StringBuilder().append(this.indent(0) + "------- Begin Message Trace -------").append(this.indent(0) + "Service -> " + exchange.getConsumer().getName()).append(this.indent(0) + "Operation -> " + exchange.getContract().getConsumerOperation().getName()).append(this.indent(0) + "Phase -> " + exchange.getPhase()).append(this.indent(0) + "State -> " + exchange.getState());
            Context ctx = exchange.getContext();
            summary.append(this.indent(0) + "Exchange Context -> ");
            for (Property p : ctx.getProperties(Scope.EXCHANGE)) {
                summary.append(this.indent(1) + p.getName() + " : " + p.getValue());
            }
            summary.append(this.indent(0) + "Message Context -> ");
            for (Property p : ctx.getProperties(Scope.valueOf((String)exchange.getPhase().toString()))) {
                summary.append(this.indent(1) + p.getName() + " : " + p.getValue());
            }
            content = null;
            try {
                Message msg = exchange.getMessage();
                content = (String)msg.getContent(String.class);
                if (InputStream.class.isAssignableFrom(msg.getContent().getClass())) {
                    msg.setContent((Object)new ByteArrayInputStream(content.getBytes()));
                } else if (Reader.class.isAssignableFrom(msg.getContent().getClass())) {
                    msg.setContent((Object)new StringReader(content));
                }
            }
            catch (Exception ex) {
                if (exchange.getMessage().getContent() == null) break block7;
                content = exchange.getMessage().getContent().toString();
            }
        }
        summary.append(this.indent(0) + "Message Content -> ").append(this.indent(0) + content);
        summary.append(this.indent(0) + "------ End Message Trace -------");
        return summary.toString();
    }

    private String indent(int column) {
        String indent = INDENT;
        if (column > 0) {
            for (int i = 0; i < column; ++i) {
                indent = indent + "\t";
            }
        }
        return indent;
    }
}

