/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.validate.Validator;
import org.switchyard.validate.ValidatorRegistry;

public class ValidateHandler
extends BaseHandler {
    private static final String KEY_VALIDATED_TYPE = "org.switchyard.validatedType";
    private static Logger _logger = Logger.getLogger(ValidateHandler.class);
    private ValidatorRegistry _registry;

    public ValidateHandler(ValidatorRegistry registry) {
        this._registry = registry;
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        Validator<?> validator = this.get(exchange);
        if (validator != null) {
            try {
                if (!this.applyValidator(exchange, validator)) {
                    throw new HandlerException("Validator '" + validator.getClass().getName() + "' returned false.  Check input payload matches requirements of the Validator implementation.");
                }
            }
            catch (SwitchYardException syEx) {
                throw new HandlerException(syEx.getMessage());
            }
        }
    }

    public void handleFault(Exchange exchange) {
        Validator<?> validator = this.get(exchange);
        if (validator != null && !this.applyValidator(exchange, validator)) {
            _logger.warn((Object)("Validator '" + validator.getClass().getName() + "' returned false.  Check input payload matches requirements of the Validator implementation."));
        }
    }

    private Validator<?> get(Exchange exchange) {
        Property contentType = exchange.getContext().getProperty("org.switchyard.contentType", Scope.activeScope((Exchange)exchange));
        Property validatedType = exchange.getContext().getProperty(KEY_VALIDATED_TYPE, Scope.activeScope((Exchange)exchange));
        if (contentType != null) {
            if (validatedType != null && contentType.getValue().equals(validatedType.getValue())) {
                return null;
            }
            return this._registry.getValidator((QName)contentType.getValue());
        }
        return null;
    }

    private boolean applyValidator(Exchange exchange, Validator validator) {
        Message message = exchange.getMessage();
        boolean validated = false;
        validated = Message.class.isAssignableFrom(validator.getType()) ? validator.validate((Object)message) : validator.validate(message.getContent(validator.getType()));
        if (validated && _logger.isDebugEnabled()) {
            _logger.debug((Object)("Validated Message (" + System.identityHashCode(message) + ") with name '" + validator.getName() + "' using validator type '" + validator.getType() + "'."));
        }
        exchange.getContext().setProperty(KEY_VALIDATED_TYPE, (Object)validator.getType(), Scope.activeScope((Exchange)exchange));
        return validated;
    }
}

