/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerChain;
import org.switchyard.ServiceReference;
import org.switchyard.internal.ExchangeImpl;
import org.switchyard.spi.Dispatcher;

class LocalDispatcher
implements Dispatcher {
    private HandlerChain _requestChain;
    private HandlerChain _replyChain;
    private ServiceReference _reference;

    LocalDispatcher(ServiceReference reference, HandlerChain requestChain, HandlerChain replyChain) {
        this._reference = reference;
        this._requestChain = requestChain;
        this._replyChain = replyChain;
    }

    @Override
    public void dispatch(Exchange exchange) {
        switch (exchange.getPhase()) {
            case IN: {
                this._requestChain.handle(exchange);
                break;
            }
            case OUT: {
                ExchangeHandler replyHandler = ((ExchangeImpl)exchange).getReplyHandler();
                if (replyHandler != null) {
                    this._replyChain.replace("consumer", replyHandler);
                }
                this._replyChain.handle(exchange);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid phase for dispatch: " + exchange.getPhase());
            }
        }
    }

    @Override
    public ServiceReference getServiceReference() {
        return this._reference;
    }
}

