/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import org.junit.Assert;
import org.junit.Test;
import org.switchyard.Scope;
import org.switchyard.internal.ContextProperty;

public class ContextPropertyTest {
    @Test
    public void testNullName() {
        try {
            new ContextProperty(null, Scope.IN, (Object)"bar");
            Assert.fail((String)"Null property name should not be permitted!");
        }
        catch (IllegalArgumentException expected) {
            return;
        }
    }

    @Test
    public void testNullScope() {
        try {
            new ContextProperty("foo", null, (Object)"bar");
            Assert.fail((String)"Null property scope should not be permitted!");
        }
        catch (IllegalArgumentException expected) {
            return;
        }
    }

    @Test
    public void testEquals() {
        ContextProperty prop1 = new ContextProperty("foo", Scope.IN, (Object)"bar");
        ContextProperty prop2 = new ContextProperty("foo", Scope.IN, (Object)"bar");
        Assert.assertTrue((boolean)prop1.equals((Object)prop2));
    }

    @Test
    public void testNotEquals() {
        ContextProperty propRef = new ContextProperty("foo", Scope.IN, (Object)"bar");
        ContextProperty propDiffName = new ContextProperty("oops", Scope.IN, (Object)"bar");
        ContextProperty propDiffScope = new ContextProperty("foo", Scope.OUT, (Object)"bar");
        ContextProperty propDiffValue = new ContextProperty("foo", Scope.IN, (Object)"nope");
        Assert.assertFalse((boolean)propRef.equals((Object)propDiffName));
        Assert.assertFalse((boolean)propRef.equals((Object)propDiffScope));
        Assert.assertFalse((boolean)propRef.equals((Object)propDiffValue));
    }
}

