/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import junit.framework.Assert;
import org.junit.Test;
import org.switchyard.Context;
import org.switchyard.Message;
import org.switchyard.internal.DefaultContext;
import org.switchyard.internal.DefaultMessage;
import org.switchyard.internal.io.Data;
import org.switchyard.internal.io.Serializer;
import org.switchyard.internal.io.SerializerType;

public final class ExchangeSerializationTests {
    private static final Serializer SERIALIZER = SerializerType.DEFAULT.instance();

    private static final <T> T serDeser(T object, Class<T> clazz) throws Exception {
        byte[] bytes = SERIALIZER.serialize(object, clazz);
        return (T)SERIALIZER.deserialize(bytes, clazz);
    }

    @Test
    public void testContextSerialization() throws Exception {
        DefaultContext ctx = this.buildContext(null);
        ctx = ExchangeSerializationTests.serDeser(ctx, DefaultContext.class);
        this.assertContext((Context)ctx);
    }

    @Test
    public void testMessageSerialization() throws Exception {
        DefaultMessage msg = this.buildMessage(null);
        msg = ExchangeSerializationTests.serDeser(msg, DefaultMessage.class);
        this.assertMessage((Message)msg);
    }

    private DefaultContext buildContext(DefaultContext ctx) {
        if (ctx == null) {
            ctx = new DefaultContext();
        }
        ctx.setProperty("foo", (Object)"bar").addLabels(new String[]{"roller derby", "karate"});
        ctx.setProperty("car", (Object)new Data.Car(new Data.Person("driver"))).addLabels(new String[]{"Mustang"});
        return ctx;
    }

    private DefaultMessage buildMessage(DefaultMessage msg) {
        if (msg == null) {
            msg = new DefaultMessage();
        }
        msg.setContent((Object)"content");
        msg.addAttachment("data", (DataSource)new MockDataSource("mock", "text/plain", "abc123"));
        return msg;
    }

    private void assertContext(Context ctx) throws Exception {
        Assert.assertEquals((Object)"bar", (Object)ctx.getProperty("foo").getValue());
        Assert.assertTrue((boolean)ctx.getProperty("foo").hasLabel("Roller Derby"));
        Assert.assertTrue((boolean)ctx.getProperty("foo").hasLabel("karate"));
        Assert.assertFalse((boolean)ctx.getProperty("foo").hasLabel("football"));
        Assert.assertEquals((String)"driver", (String)((Data.Car)ctx.getProperty("car").getValue()).getDriver().getName());
        Assert.assertTrue((boolean)ctx.getProperty("car").hasLabel("mUsTaNg"));
        Assert.assertFalse((boolean)ctx.getProperty("car").hasLabel("Pinto"));
    }

    private void assertMessage(Message msg) throws Exception {
        Assert.assertEquals((Object)"content", (Object)msg.getContent());
        InputStream is = msg.getAttachment("data").getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buff = new byte[6];
        int read = 0;
        while ((read = is.read(buff)) != -1) {
            baos.write(buff, 0, read);
        }
        Assert.assertEquals((String)"abc123", (String)new String(baos.toByteArray()));
    }

    private static final class MockDataSource
    implements DataSource {
        private String _name;
        private String _contentType;
        private String _content;

        private MockDataSource(String name, String contentType, String content) {
            this._name = name;
            this._contentType = contentType;
            this._content = content;
        }

        public String getName() {
            return this._name;
        }

        public String getContentType() {
            return this._contentType;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this._content.getBytes());
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }
    }
}

