/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.handlers;

import java.util.Set;
import org.switchyard.BaseHandler;
import org.switchyard.Exchange;
import org.switchyard.ExchangePhase;
import org.switchyard.HandlerException;
import org.switchyard.ServiceSecurity;
import org.switchyard.policy.Policy;
import org.switchyard.policy.PolicyUtil;
import org.switchyard.policy.SecurityPolicy;
import org.switchyard.security.SecurityContext;
import org.switchyard.security.SecurityProvider;
import org.switchyard.security.credential.ConfidentialityCredential;
import org.switchyard.security.credential.PrincipalCredential;

public class SecurityHandler
extends BaseHandler {
    private final SecurityProvider _securityProvider = SecurityProvider.instance();
    private final ServiceSecurity _serviceSecurity;

    public SecurityHandler(ServiceSecurity serviceSecurity) {
        this._serviceSecurity = serviceSecurity;
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        if (ExchangePhase.IN.equals((Object)exchange.getPhase())) {
            SecurityContext securityContext = SecurityContext.get();
            if (PolicyUtil.isRequired((Exchange)exchange, (Policy)SecurityPolicy.CLIENT_AUTHENTICATION) && !PolicyUtil.isProvided((Exchange)exchange, (Policy)SecurityPolicy.CLIENT_AUTHENTICATION)) {
                if (this.isClientAuthenticationProvided(securityContext)) {
                    PolicyUtil.provide((Exchange)exchange, (Policy)SecurityPolicy.CLIENT_AUTHENTICATION);
                } else {
                    boolean success = this._securityProvider.authenticate(this._serviceSecurity, securityContext);
                    if (success) {
                        PolicyUtil.provide((Exchange)exchange, (Policy)SecurityPolicy.CLIENT_AUTHENTICATION);
                    }
                }
            }
            if (PolicyUtil.isRequired((Exchange)exchange, (Policy)SecurityPolicy.CONFIDENTIALITY) && !PolicyUtil.isProvided((Exchange)exchange, (Policy)SecurityPolicy.CONFIDENTIALITY) && this.isConfidentialityProvided(securityContext)) {
                PolicyUtil.provide((Exchange)exchange, (Policy)SecurityPolicy.CONFIDENTIALITY);
            }
        }
    }

    private boolean isClientAuthenticationProvided(SecurityContext securityContext) {
        Set creds = securityContext.getCredentials(PrincipalCredential.class);
        for (PrincipalCredential cred : creds) {
            if (cred.getPrincipal() == null || !cred.isTrusted()) continue;
            return true;
        }
        return false;
    }

    private boolean isConfidentialityProvided(SecurityContext securityContext) {
        Set creds = securityContext.getCredentials(ConfidentialityCredential.class);
        for (ConfidentialityCredential cred : creds) {
            if (!cred.isConfidential()) continue;
            return true;
        }
        return false;
    }
}

