/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal;

import java.util.EventObject;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.Context;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.ExchangePattern;
import org.switchyard.ExchangePhase;
import org.switchyard.ExchangeState;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.Service;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.internal.DefaultContext;
import org.switchyard.internal.DefaultMessage;
import org.switchyard.metadata.BaseExchangeContract;
import org.switchyard.metadata.ExchangeContract;
import org.switchyard.metadata.ServiceOperation;
import org.switchyard.runtime.event.ExchangeCompletionEvent;
import org.switchyard.spi.Dispatcher;

public class ExchangeImpl
implements Exchange {
    private static Logger _log = Logger.getLogger(ExchangeImpl.class);
    private ExchangePhase _phase;
    private Message _message;
    private ExchangeState _state = ExchangeState.OK;
    private Dispatcher _dispatch;
    private ExchangeHandler _replyHandler;
    private ServiceDomain _domain;
    private Long _startTime;
    private Context _context;
    private ServiceReference _consumer;
    private Service _provider;
    private BaseExchangeContract _contract = new BaseExchangeContract();

    public ExchangeImpl(ServiceDomain domain) {
        this(domain, null);
    }

    public ExchangeImpl(ServiceDomain domain, ExchangeHandler replyHandler) {
        this._domain = domain;
        this._replyHandler = replyHandler;
        this._context = new DefaultContext();
    }

    public Context getContext() {
        return this._context;
    }

    public Message getMessage() {
        return this._message;
    }

    public synchronized void send(Message message) {
        this.assertMessageOK(message);
        if (this._phase == null) {
            this._phase = ExchangePhase.IN;
            this.initInContentType();
        } else if (this._phase.equals((Object)ExchangePhase.IN)) {
            this._phase = ExchangePhase.OUT;
            this.initOutContentType();
            this._context.setProperty("org.switchyard.relatesTo", this._context.getProperty("org.switchyard.messageId", Scope.IN).getValue(), Scope.OUT);
        } else {
            throw new IllegalStateException("Send message not allowed for exchange in phase " + this._phase);
        }
        this.sendInternal(message);
    }

    public synchronized void sendFault(Message message) {
        this.assertMessageOK(message);
        if (this._phase == null) {
            throw new IllegalStateException("Send fault no allowed on new exchanges");
        }
        this._phase = ExchangePhase.OUT;
        this._state = ExchangeState.FAULT;
        this.initFaultContentType();
        this.sendInternal(message);
    }

    public ExchangeState getState() {
        return this._state;
    }

    public Dispatcher getDispatcher() {
        return this._dispatch;
    }

    public ExchangeHandler getReplyHandler() {
        return this._replyHandler;
    }

    public void setOutputDispatcher(Dispatcher dispatch) {
        this._dispatch = dispatch;
    }

    private void sendInternal(Message message) {
        if (this._startTime == null) {
            this._startTime = System.nanoTime();
        }
        ExchangePhase sendPhase = this._phase;
        this._message = message;
        this._context.setProperty("org.switchyard.messageId", (Object)UUID.randomUUID().toString(), Scope.activeScope((Exchange)this));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Sending " + this._phase + " Message (" + System.identityHashCode(message) + ") on " + this._contract.getConsumerOperation().getExchangePattern() + " Exchange (" + this.instanceHash() + ") for Service '" + this._consumer.getName() + "', operation '" + this._contract.getProviderOperation() + "'.  Exchange state: " + this._state));
        }
        if (ExchangeState.FAULT.equals((Object)this._state) && this._replyHandler == null) {
            String faultContent;
            try {
                faultContent = (String)this._message.getContent(String.class);
            }
            catch (Exception ex) {
                faultContent = this._message.getContent().toString();
            }
            _log.warn((Object)("Fault generated during exchange without a handler: " + faultContent));
        } else {
            this._dispatch.dispatch(this);
        }
        if (this.isDone(sendPhase)) {
            long duration = System.nanoTime() - this._startTime;
            this.getContext().setProperty("org.switchyard.exchangeDurationMS", (Object)TimeUnit.MILLISECONDS.convert(duration, TimeUnit.NANOSECONDS));
            this._domain.getEventPublisher().publish((EventObject)new ExchangeCompletionEvent(this));
        }
    }

    private int instanceHash() {
        return System.identityHashCode(this);
    }

    private void assertMessageOK(Message message) {
        if (message == null) {
            throw new IllegalArgumentException("Invalid null 'message' argument in method call.");
        }
        if (this._state == ExchangeState.FAULT) {
            throw new IllegalStateException("Exchange instance is in a FAULT state.");
        }
    }

    public Message createMessage() {
        DefaultMessage msg = new DefaultMessage();
        if (this._domain != null) {
            msg.setTransformerRegistry(this._domain.getTransformerRegistry());
        }
        return msg;
    }

    public ExchangePhase getPhase() {
        return this._phase;
    }

    public ExchangeContract getContract() {
        return this._contract;
    }

    public ServiceReference getConsumer() {
        return this._consumer;
    }

    public Service getProvider() {
        return this._provider;
    }

    public ExchangeImpl consumer(ServiceReference consumer, ServiceOperation operation) {
        if (this._phase != null) {
            throw new IllegalStateException("Cannot change consumer metadata after message has been sent on exchange.");
        }
        if (this._replyHandler == null && operation.getExchangePattern() == ExchangePattern.IN_OUT) {
            throw new SwitchYardException("Invalid consumer contract - IN_OUT exchanges require a reply handler.");
        }
        this._consumer = consumer;
        this._contract.setConsumerOperation(operation);
        return this;
    }

    public ExchangeImpl provider(Service provider, ServiceOperation operation) {
        if (this._phase == ExchangePhase.OUT) {
            throw new IllegalStateException("Cannot change provider metadata after provider has been invoked!");
        }
        this._provider = provider;
        this._contract.setProviderOperation(operation);
        return this;
    }

    protected void setPhase(ExchangePhase phase) {
        this._phase = phase;
    }

    private void initInContentType() {
        QName exchangeInputType = this._contract.getConsumerOperation().getInputType();
        if (exchangeInputType != null) {
            this._context.setProperty("org.switchyard.contentType", (Object)exchangeInputType, Scope.IN);
        }
    }

    private void initOutContentType() {
        QName serviceOperationOutputType = this._contract.getProviderOperation().getOutputType();
        if (serviceOperationOutputType != null) {
            this._context.setProperty("org.switchyard.contentType", (Object)serviceOperationOutputType, Scope.OUT);
        }
    }

    private void initFaultContentType() {
        QName serviceOperationFaultType;
        if (this._contract.getProviderOperation() != null && (serviceOperationFaultType = this._contract.getProviderOperation().getFaultType()) != null) {
            this._context.setProperty("org.switchyard.contentType", (Object)serviceOperationFaultType, Scope.OUT);
        }
    }

    private boolean isDone(ExchangePhase phase) {
        ExchangePattern mep = this._contract.getConsumerOperation().getExchangePattern();
        return ExchangePhase.IN.equals((Object)phase) && ExchangePattern.IN_ONLY.equals((Object)mep) || ExchangePhase.OUT.equals((Object)phase) && ExchangePattern.IN_OUT.equals((Object)mep);
    }
}

